/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.lang.reflect.Field;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.commandline.ArgumentParser;
import org.apache.ignite.internal.commandline.CommandsProvider;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.apache.ignite.internal.commandline.GridConsole;
import org.apache.ignite.internal.commandline.GridConsoleAdapter;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.logger.IgniteLoggerEx;
import org.apache.ignite.internal.management.IgniteCommandRegistry;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.CliConfirmArgument;
import org.apache.ignite.internal.management.api.CliSubcommandsWithPrefix;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.CommandsRegistry;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.cache.CacheCommand;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.spring.IgniteSpringHelperImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

public class CommandHandler {
    static final String CMD_HELP = "--help";
    public static final String CONFIRM_MSG = "y";
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 1;
    public static final int EXIT_CODE_CONNECTION_FAILED = 2;
    public static final int ERR_AUTHENTICATION_FAILED = 3;
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 4;
    private static final long DFLT_PING_INTERVAL = 5000L;
    private static final long DFLT_PING_TIMEOUT = 30000L;
    public static final String DFLT_HOST = "127.0.0.1";
    public static final int DFLT_PORT = 10800;
    public static final String IGNITE_CONTROL_UTILITY_USE_CONNECTOR_CONNECTION = "IGNITE_CONTROL_UTILITY_USE_CONNECTOR_CONNECTION";
    private final Scanner in = new Scanner(System.in);
    public static final String UTILITY_NAME = "control.(sh|bat)";
    private final IgniteLogger logger;
    private final IgniteCommandRegistry registry = new IgniteCommandRegistry();
    protected final String ses = U.id8((UUID)UUID.randomUUID());
    public GridConsole console = GridConsoleAdapter.getInstance();
    private Object lastOperationRes;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static void main(String[] args) {
        CommandHandler hnd = new CommandHandler();
        System.exit(hnd.execute(Arrays.asList(args)));
    }

    public static IgniteLogger setupJavaLogger(String appName, Class<?> cls) {
        try {
            IgniteLogger log = U.initLogger(null, (String)appName, null, (String)U.defaultWorkDirectory()).getLogger((Object)(cls.getName() + "Log"));
            if (log instanceof IgniteLoggerEx) {
                ((IgniteLoggerEx)log).addConsoleAppender(true);
            }
            return log;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public CommandHandler() {
        this(CommandHandler.setupJavaLogger("control-utility", CommandHandler.class));
    }

    public CommandHandler(IgniteLogger logger) {
        this.logger = logger;
        Iterable it = U.loadService(CommandsProvider.class);
        if (!F.isEmpty((Iterable)it)) {
            for (CommandsProvider provider : it) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering pluggable commands provider: " + provider);
                }
                provider.commands().forEach(cmd -> {
                    String k = CommandUtils.cmdText((Command)cmd);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Registering command: " + k);
                    }
                    if (this.registry.command(k) != null) {
                        throw new IllegalArgumentException("Found conflict for command " + k + ". Provider " + provider + " tries to register command " + cmd + ", but this command has already been registered " + this.registry.command(k));
                    }
                    this.registry.register(cmd);
                });
            }
        }
    }

    /*
     * Exception decompiling
     */
    public <A extends IgniteDataTransferObject> int execute(List<String> rawArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isHelp(List<String> rawArgs) {
        if (F.isEmpty(rawArgs)) {
            return true;
        }
        if (rawArgs.size() > 2) {
            return false;
        }
        boolean help = false;
        boolean experimental = false;
        for (String arg : rawArgs) {
            if (CMD_HELP.equalsIgnoreCase(arg)) {
                help = true;
                continue;
            }
            if ("--enable-experimental".equalsIgnoreCase(arg)) {
                experimental = true;
                continue;
            }
            return false;
        }
        return help || experimental;
    }

    private boolean isSSLMisconfigurationError(Throwable e) {
        return e != null && e.getMessage() != null && e.getMessage().contains("SSL");
    }

    private boolean isConnectionClosedSilentlyException(Throwable e) {
        if (e instanceof ClientConnectionException && e.getMessage().startsWith("Channel is closed")) {
            return true;
        }
        if (!(e instanceof GridClientDisconnectedException)) {
            return false;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return false;
        }
        return (cause = cause.getCause()) instanceof GridClientConnectionResetException && cause.getMessage() != null && cause.getMessage().contains("Failed to perform handshake");
    }

    private String argumentsToString(List<String> rawArgs) {
        boolean hide = false;
        SB sb = new SB();
        for (int i = 0; i < rawArgs.size(); ++i) {
            if (hide) {
                sb.a("***** ");
                hide = false;
                continue;
            }
            String arg = rawArgs.get(i);
            sb.a(arg).a(' ');
            hide = ArgumentParser.isSensitiveArgument(arg);
        }
        return sb.toString();
    }

    private ClientConfiguration clientConfiguration(ConnectionAndSslParameters args) throws IgniteCheckedException {
        ClientConfiguration clientCfg = new ClientConfiguration();
        clientCfg.setAddresses(new String[]{args.host() + ":" + args.port()});
        if (!F.isEmpty((String)args.userName())) {
            clientCfg.setUserName(args.userName());
            clientCfg.setUserPassword(args.password());
        }
        if (!F.isEmpty((String)args.sslKeyStorePath()) || !F.isEmpty((String)args.sslFactoryConfigPath())) {
            if (!F.isEmpty((String)args.sslKeyStorePath()) && !F.isEmpty((String)args.sslFactoryConfigPath())) {
                throw new IllegalArgumentException("Incorrect SSL configuration. SSL factory config path should not be specified simultaneously with other SSL options like keystore path.");
            }
            clientCfg.setSslContextFactory(this.createSslSupportFactory(args));
            clientCfg.setSslMode(SslMode.REQUIRED);
        }
        clientCfg.setClusterDiscoveryEnabled(false);
        return clientCfg;
    }

    @NotNull
    private GridClientConfiguration getClientConfiguration(ConnectionAndSslParameters args) throws IgniteCheckedException {
        return this.getClientConfiguration(args.userName(), args.password(), args);
    }

    @NotNull
    private GridClientConfiguration getClientConfiguration(String userName, String password, ConnectionAndSslParameters args) throws IgniteCheckedException {
        GridClientConfiguration clientCfg = new GridClientConfiguration();
        clientCfg.setPingInterval(args.pingInterval());
        clientCfg.setPingTimeout(args.pingTimeout());
        clientCfg.setServers(Collections.singletonList(args.host() + ":" + args.port()));
        if (!F.isEmpty((String)userName)) {
            clientCfg.setSecurityCredentialsProvider(this.getSecurityCredentialsProvider(userName, password, clientCfg));
        }
        if (!F.isEmpty((String)args.sslKeyStorePath()) || !F.isEmpty((String)args.sslFactoryConfigPath())) {
            if (!F.isEmpty((String)args.sslKeyStorePath()) && !F.isEmpty((String)args.sslFactoryConfigPath())) {
                throw new IllegalArgumentException("Incorrect SSL configuration. SSL factory config path should not be specified simultaneously with other SSL options like keystore path.");
            }
            clientCfg.setSslContextFactory(this.createSslSupportFactory(args));
        }
        return clientCfg;
    }

    @NotNull
    private SecurityCredentialsProvider getSecurityCredentialsProvider(String userName, String password, GridClientConfiguration clientCfg) throws IgniteCheckedException {
        SecurityCredentialsProvider securityCredential = clientCfg.getSecurityCredentialsProvider();
        if (securityCredential == null) {
            return new SecurityCredentialsBasicProvider(new SecurityCredentials(userName, password));
        }
        SecurityCredentials credential = securityCredential.credentials();
        credential.setLogin((Object)userName);
        credential.setPassword((Object)password);
        return securityCredential;
    }

    @NotNull
    private Factory<SSLContext> createSslSupportFactory(ConnectionAndSslParameters args) throws IgniteCheckedException {
        if (!F.isEmpty((String)args.sslFactoryConfigPath())) {
            URL springCfg = IgniteUtils.resolveSpringUrl((String)args.sslFactoryConfigPath());
            ApplicationContext ctx = IgniteSpringHelperImpl.applicationContext((URL)springCfg, (String[])new String[0]);
            return (Factory)ctx.getBean(Factory.class);
        }
        SslContextFactory factory = new SslContextFactory();
        if (args.sslProtocol().length > 1) {
            factory.setProtocols(args.sslProtocol());
        } else {
            factory.setProtocol(args.sslProtocol()[0]);
        }
        factory.setKeyAlgorithm(args.sslKeyAlgorithm());
        factory.setCipherSuites(args.getSslCipherSuites());
        factory.setKeyStoreFilePath(args.sslKeyStorePath());
        if (args.sslKeyStorePassword() != null) {
            factory.setKeyStorePassword(args.sslKeyStorePassword());
        } else {
            char[] keyStorePwd = this.requestPasswordFromConsole("SSL keystore password: ");
            args.sslKeyStorePassword(keyStorePwd);
            factory.setKeyStorePassword(keyStorePwd);
        }
        factory.setKeyStoreType(args.sslKeyStoreType());
        if (F.isEmpty((String)args.sslTrustStorePath())) {
            factory.setTrustManagers(new TrustManager[]{SslContextFactory.getDisabledTrustManager()});
        } else {
            factory.setTrustStoreFilePath(args.sslTrustStorePath());
            if (args.sslTrustStorePassword() != null) {
                factory.setTrustStorePassword(args.sslTrustStorePassword());
            } else {
                char[] trustStorePwd = this.requestPasswordFromConsole("SSL truststore password: ");
                args.sslTrustStorePassword(trustStorePwd);
                factory.setTrustStorePassword(trustStorePwd);
            }
            factory.setTrustStoreType(args.sslTrustStoreType());
        }
        return factory;
    }

    public <T> T getLastOperationResult() {
        return (T)this.lastOperationRes;
    }

    private String readLine(String prompt) {
        System.out.print(prompt);
        return this.in.nextLine();
    }

    private boolean confirm(String str) {
        if (str == null) {
            return true;
        }
        String prompt = str + System.lineSeparator() + "Press 'y' to continue . . . ";
        return CONFIRM_MSG.equalsIgnoreCase(this.readLine(prompt));
    }

    public static boolean isAuthError(Throwable e) {
        return X.hasCause((Throwable)e, (Class[])new Class[]{GridClientAuthenticationException.class}) || X.hasCause((Throwable)e, (Class[])new Class[]{ClientAuthenticationException.class});
    }

    private static boolean isConnectionError(Throwable e) {
        return e instanceof GridClientClosedException || e instanceof GridClientConnectionResetException || e instanceof GridClientDisconnectedException || e instanceof GridClientHandshakeException || e instanceof GridServerUnreachableException || X.hasCause((Throwable)e, (Class[])new Class[]{ClientConnectionException.class});
    }

    private char[] requestPasswordFromConsole(String msg) {
        if (this.console == null) {
            throw new UnsupportedOperationException("Failed to securely read password (console is unavailable): " + msg);
        }
        return this.console.readPassword(msg, new Object[0]);
    }

    private String requestDataFromConsole(String msg) {
        if (this.console != null) {
            return this.console.readLine(msg, new Object[0]);
        }
        Scanner scanner = new Scanner(System.in);
        this.logger.info(msg);
        return scanner.nextLine();
    }

    private void printHelp(List<String> rawArgs) {
        boolean experimentalEnabled = rawArgs.stream().anyMatch("--enable-experimental"::equalsIgnoreCase) || IgniteSystemProperties.getBoolean((String)"IGNITE_ENABLE_EXPERIMENTAL_COMMAND");
        this.logger.info("Control utility script is used to execute admin commands on cluster or get common cluster info. The command has the following syntax:");
        this.logger.info("");
        this.logger.info("  " + CommandUtils.join((String)" ", (Object[])new Object[]{CommandUtils.join((String)" ", (Object[])new Object[]{UTILITY_NAME, CommandUtils.join((String)" ", (Object[])new ArgumentParser(this.logger, this.registry).getCommonOptions())}), CommandUtils.asOptional((String)"command", (boolean)true), "<command_parameters>"}));
        this.logger.info("");
        this.logger.info("");
        this.logger.info("This utility can do the following commands:");
        this.registry.commands().forEachRemaining(e -> {
            if (experimentalEnabled || !((Command)e.getValue()).getClass().isAnnotationPresent(IgniteExperimental.class)) {
                if (Objects.equals(((Command)e.getValue()).getClass(), CacheCommand.class)) {
                    this.logger.info("");
                    this.logger.info("View caches information in a cluster. For more details type:");
                    this.logger.info("    control.(sh|bat) --cache help");
                    return;
                }
                this.printUsage(this.logger, (Command)e.getValue());
            }
        });
        this.logger.info("");
        this.logger.info("By default commands affecting the cluster require interactive confirmation.");
        this.logger.info("Use --yes option to disable it.");
        this.logger.info("");
        this.logger.info("Default values:");
        this.logger.info("    HOST_OR_IP=127.0.0.1");
        this.logger.info("    PORT=10800");
        this.logger.info("    PING_INTERVAL=5000");
        this.logger.info("    PING_TIMEOUT=30000");
        this.logger.info("    SSL_PROTOCOL=TLS");
        this.logger.info("    SSL_KEY_ALGORITHM=" + SslContextFactory.DFLT_KEY_ALGORITHM);
        this.logger.info("    KEYSTORE_TYPE=" + SslContextFactory.DFLT_STORE_TYPE);
        this.logger.info("    TRUSTSTORE_TYPE=" + SslContextFactory.DFLT_STORE_TYPE);
        this.logger.info("");
        this.logger.info("Exit codes:");
        this.logger.info("    0 - successful execution.");
        this.logger.info("    1 - invalid arguments.");
        this.logger.info("    2 - connection failed.");
        this.logger.info("    3 - authentication failed.");
        this.logger.info("    4 - unexpected error.");
    }

    public void printUsage(IgniteLogger logger, Command<?, ?> cmd) {
        if (cmd instanceof CacheCommand || cmd instanceof CacheCommand.CacheHelpCommand) {
            this.printCacheHelpHeader(logger);
        }
        CommandHandler.usage(cmd, Collections.emptyList(), logger);
        if (cmd instanceof CacheCommand || cmd instanceof CacheCommand.CacheHelpCommand) {
            logger.info("");
        }
    }

    private void printCacheHelpHeader(IgniteLogger logger) {
        logger.info("  The '--cache subcommand' is used to get information about and perform actions with caches. The command has the following syntax:");
        logger.info("");
        logger.info("  " + CommandUtils.join((String)" ", (Object[])new Object[]{UTILITY_NAME, CommandUtils.join((String)" ", (Object[])new ArgumentParser(logger, null).getCommonOptions())}) + " --cache [subcommand] <subcommand_parameters>");
        logger.info("");
        logger.info("  The subcommands that take [nodeId] as an argument ('list', 'find_garbage', 'contention' and 'validate_indexes') will be executed on the given node or on all server nodes if the option is not specified. Other commands will run on a random server node.");
        logger.info("");
        logger.info("");
        logger.info("  Subcommands:");
    }

    public static void usage(Command<?, ?> cmd, List<Command<?, ?>> parents, IgniteLogger logger) {
        if (CommandUtils.executable(cmd)) {
            logger.info("");
            if (cmd.getClass().isAnnotationPresent(IgniteExperimental.class)) {
                logger.info("  [EXPERIMENTAL]");
            }
            CommandHandler.printExample(cmd, parents, logger);
            if (CommandUtils.hasDescribedParameters(cmd)) {
                logger.info("");
                logger.info("    Parameters:");
                LengthCalculator lenCalc = new LengthCalculator();
                CommandUtils.visitCommandParams((Class)cmd.argClass(), (Consumer)lenCalc, (Consumer)lenCalc, (argGrp, flds) -> flds.forEach(lenCalc));
                Consumer<Field> printer = fld -> {
                    BiConsumer<String, String> logParam = (name, description) -> {
                        if (F.isEmpty((String)description)) {
                            return;
                        }
                        logger.info("      " + U.extendToLen((String)name, (int)lenCalc.length) + "  - " + description + ".");
                    };
                    logParam.accept(CommandUtils.parameterExample((Field)fld, (boolean)false), fld.getAnnotation(Argument.class).description());
                    if (fld.isAnnotationPresent(EnumDescription.class)) {
                        EnumDescription enumDesc = fld.getAnnotation(EnumDescription.class);
                        String[] names = CommandHandler.formattedEnumNames(fld);
                        String[] descriptions = enumDesc.descriptions();
                        for (int i = 0; i < names.length; ++i) {
                            logParam.accept(names[i], descriptions[i]);
                        }
                    }
                };
                CommandUtils.visitCommandParams((Class)cmd.argClass(), printer, printer, (argGrp, flds) -> {
                    flds.stream().filter(fld -> fld.isAnnotationPresent(Positional.class)).forEach(printer);
                    flds.stream().filter(fld -> !fld.isAnnotationPresent(Positional.class)).forEach(printer);
                });
            }
        }
        if (cmd instanceof CommandsRegistry) {
            ArrayList parents0 = new ArrayList(parents);
            parents0.add(cmd);
            ((CommandsRegistry)cmd).commands().forEachRemaining(cmd0 -> CommandHandler.usage((Command)cmd0.getValue(), parents0, logger));
        }
    }

    private static void printExample(Command<?, ?> cmd, List<Command<?, ?>> parents, IgniteLogger logger) {
        logger.info("  " + cmd.description() + ":");
        StringBuilder bldr = new StringBuilder("    control.(sh|bat)");
        CommandName name = new CommandName();
        parents.forEach(name);
        name.accept(cmd);
        bldr.append(name.name.toString());
        BiConsumer<Boolean, Field> paramPrinter = (spaceReq, fld) -> {
            if (spaceReq.booleanValue()) {
                bldr.append(' ');
            }
            bldr.append(CommandUtils.parameterExample((Field)fld, (boolean)true));
        };
        CommandUtils.visitCommandParams((Class)cmd.argClass(), fld -> bldr.append(' ').append(CommandUtils.valueExample((Field)fld)), fld -> paramPrinter.accept(true, (Field)fld), (argGrp, flds) -> {
            if (argGrp.onlyOneOf()) {
                bldr.append(' ');
                if (argGrp.optional()) {
                    bldr.append('[');
                }
                for (int i = 0; i < flds.size(); ++i) {
                    if (i != 0) {
                        bldr.append('|');
                    }
                    paramPrinter.accept(false, (Field)flds.get(i));
                }
                if (argGrp.optional()) {
                    bldr.append(']');
                }
            } else {
                flds.stream().filter(fld -> fld.isAnnotationPresent(Positional.class)).forEach(fld -> bldr.append(' ').append(CommandUtils.valueExample((Field)fld)));
                flds.stream().filter(fld -> !fld.isAnnotationPresent(Positional.class)).forEach(fld -> paramPrinter.accept(true, (Field)fld));
            }
        });
        if (cmd.argClass().isAnnotationPresent(CliConfirmArgument.class)) {
            bldr.append(' ').append(CommandUtils.asOptional((String)"--yes", (boolean)true));
        }
        logger.info(bldr.toString());
    }

    private static String[] formattedEnumNames(Field fld) {
        EnumDescription desc = fld.getAnnotation(EnumDescription.class);
        String indent = fld.isAnnotationPresent(Positional.class) ? "" : "  ";
        return (String[])Arrays.stream(desc.names()).map(s -> indent + s).toArray(String[]::new);
    }

    public static boolean useConnectorConnection() {
        return IgniteSystemProperties.getBoolean((String)IGNITE_CONTROL_UTILITY_USE_CONNECTOR_CONNECTION);
    }

    public static class CommandName
    implements Consumer<Object> {
        private boolean prefixInclude = true;
        private String parentPrefix;
        StringBuilder name = new StringBuilder();

        @Override
        public void accept(Object cmd) {
            this.name.append(' ');
            if (this.prefixInclude) {
                this.name.append("--");
            }
            String cmdName = CommandUtils.toFormattedCommandName(cmd.getClass());
            String parentPrefix0 = this.parentPrefix;
            this.parentPrefix = cmdName;
            if (!F.isEmpty((String)parentPrefix0)) {
                cmdName = cmdName.replaceFirst(parentPrefix0 + "-", "");
                if (!this.prefixInclude) {
                    cmdName = cmdName.replaceAll("-", "_");
                }
            }
            this.name.append(cmdName);
            if (cmd instanceof CommandsRegistry) {
                this.prefixInclude = cmd.getClass().isAnnotationPresent(CliSubcommandsWithPrefix.class);
            }
        }
    }

    private static class LengthCalculator
    implements Consumer<Field> {
        int length;

        private LengthCalculator() {
        }

        @Override
        public void accept(Field fld) {
            if (!CommandUtils.hasDescription((Field)fld)) {
                return;
            }
            this.length = Math.max(this.length, CommandUtils.parameterExample((Field)fld, (boolean)false).length());
            if (fld.isAnnotationPresent(EnumDescription.class)) {
                for (String name : CommandHandler.formattedEnumNames(fld)) {
                    this.length = Math.max(this.length, name.length());
                }
            }
        }
    }
}

