/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing.opencensus;

import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import org.apache.ignite.spi.IgniteSpiException;

public class OpenCensusTraceExporter {
    private final SpanExporter.Handler hnd;
    private String hndName;

    public OpenCensusTraceExporter(SpanExporter.Handler hnd) {
        this.hnd = hnd;
    }

    public void start(String igniteInstanceName) {
        try {
            this.hndName = this.hnd.getClass().getName() + "-" + igniteInstanceName;
            Tracing.getExportComponent().getSpanExporter().registerHandler(this.hndName, this.hnd);
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to start " + this, (Throwable)e);
        }
    }

    public void stop() {
        Tracing.getExportComponent().getSpanExporter().unregisterHandler(this.hndName);
    }

    public String toString() {
        return "OpenCensus trace exporter [hndName=" + this.hndName + ", hnd=" + this.hnd + "]";
    }
}

