/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata.enums;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tsfile.enums.TSDataType;

public enum TSEncoding {
    PLAIN(0),
    DICTIONARY(1),
    RLE(2),
    DIFF(3),
    TS_2DIFF(4),
    BITMAP(5),
    GORILLA_V1(6),
    REGULAR(7),
    GORILLA(8),
    ZIGZAG(9),
    FREQ(10),
    CHIMP(11),
    SPRINTZ(12),
    RLBE(13);

    private final byte type;
    public static final Map<TSDataType, Set<TSEncoding>> TYPE_SUPPORTED_ENCODINGS;

    private TSEncoding(byte type) {
        this.type = type;
    }

    public static TSEncoding deserialize(byte encoding) {
        return TSEncoding.getTsEncoding(encoding);
    }

    private static TSEncoding getTsEncoding(byte encoding) {
        switch (encoding) {
            case 0: {
                return PLAIN;
            }
            case 1: {
                return DICTIONARY;
            }
            case 2: {
                return RLE;
            }
            case 3: {
                return DIFF;
            }
            case 4: {
                return TS_2DIFF;
            }
            case 5: {
                return BITMAP;
            }
            case 6: {
                return GORILLA_V1;
            }
            case 7: {
                return REGULAR;
            }
            case 8: {
                return GORILLA;
            }
            case 9: {
                return ZIGZAG;
            }
            case 11: {
                return CHIMP;
            }
            case 12: {
                return SPRINTZ;
            }
            case 13: {
                return RLBE;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + encoding);
    }

    public static boolean isSupported(TSDataType type, TSEncoding encoding) {
        return TYPE_SUPPORTED_ENCODINGS.get((Object)type).contains((Object)encoding);
    }

    public boolean isSupported(TSDataType type) {
        return TYPE_SUPPORTED_ENCODINGS.get((Object)type).contains((Object)this);
    }

    public static int getSerializedSize() {
        return 1;
    }

    public byte serialize() {
        return this.type;
    }

    static {
        TYPE_SUPPORTED_ENCODINGS = new EnumMap<TSDataType, Set<TSEncoding>>(TSDataType.class);
        HashSet<TSEncoding> booleanSet = new HashSet<TSEncoding>();
        booleanSet.add(PLAIN);
        booleanSet.add(RLE);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.BOOLEAN, booleanSet);
        HashSet<TSEncoding> intSet = new HashSet<TSEncoding>();
        intSet.add(PLAIN);
        intSet.add(RLE);
        intSet.add(TS_2DIFF);
        intSet.add(GORILLA);
        intSet.add(ZIGZAG);
        intSet.add(CHIMP);
        intSet.add(SPRINTZ);
        intSet.add(RLBE);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.INT32, intSet);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.INT64, intSet);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.TIMESTAMP, intSet);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.DATE, intSet);
        HashSet<TSEncoding> floatSet = new HashSet<TSEncoding>();
        floatSet.add(PLAIN);
        floatSet.add(RLE);
        floatSet.add(TS_2DIFF);
        floatSet.add(GORILLA_V1);
        floatSet.add(GORILLA);
        floatSet.add(CHIMP);
        floatSet.add(SPRINTZ);
        floatSet.add(RLBE);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.FLOAT, floatSet);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.DOUBLE, floatSet);
        HashSet<TSEncoding> textSet = new HashSet<TSEncoding>();
        textSet.add(PLAIN);
        textSet.add(DICTIONARY);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.TEXT, textSet);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.STRING, textSet);
        HashSet<TSEncoding> blobSet = new HashSet<TSEncoding>();
        blobSet.add(PLAIN);
        TYPE_SUPPORTED_ENCODINGS.put(TSDataType.BLOB, blobSet);
    }
}

