/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RoutingResults {
    final List<String> successedRoutings;
    final List<String> failedRoutings;
    private final CompletableFuture<Void> mergedAction;

    public RoutingResults(List<String> successedRoutings, List<String> failedRoutings, CompletableFuture<Void> mergedAction) {
        this.successedRoutings = successedRoutings;
        this.failedRoutings = failedRoutings;
        this.mergedAction = mergedAction;
    }

    public boolean isAllSuccess() {
        return this.failedRoutings.isEmpty();
    }

    public boolean isAllFailed() {
        return this.successedRoutings.isEmpty() && !this.failedRoutings.isEmpty();
    }

    public CompletableFuture<Void> completableFuture() {
        return this.mergedAction;
    }

    public static RoutingResults preroutingError() {
        return new RoutingResults(Collections.emptyList(), Collections.emptyList(), CompletableFuture.completedFuture(null));
    }

    public String toString() {
        return "RoutingResults{successedRoutings=" + this.successedRoutings + ", failedRoutings=" + this.failedRoutings + ", mergedAction=" + this.mergedAction + '}';
    }
}

