/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.SessionRegistry;
import io.moquette.broker.Utils;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.persistence.EnqueuedMessageValueType;
import io.moquette.persistence.PropertyDataType;
import io.moquette.persistence.SerdesUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;

class SegmentedPersistentQueueSerDes {
    SegmentedPersistentQueueSerDes() {
    }

    public ByteBuffer toBytes(SessionRegistry.EnqueuedMessage message) {
        int memorySize = this.getMemory(message);
        ByteBuffer payload = ByteBuffer.allocate(memorySize);
        payload.mark();
        this.write(message, payload);
        payload.reset();
        return payload;
    }

    private void write(SessionRegistry.EnqueuedMessage obj, ByteBuffer buff) {
        if (obj instanceof SessionRegistry.PublishedMessage) {
            buff.put((byte)MessageType.PUBLISHED_MESSAGE.ordinal());
            SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
            buff.put((byte)casted.getPublishingQos().value());
            String topic = casted.getTopic().toString();
            this.writeTopic(buff, topic);
            this.writeMessageExpiry(buff, casted.getMessageExpiry());
            this.writePayload(buff, casted.getPayload());
            if (EnqueuedMessageValueType.hasProperties(casted)) {
                buff.put((byte)1);
                this.writeProperties(buff, casted.getMqttProperties());
            } else {
                buff.put((byte)0);
            }
        } else if (obj instanceof SessionRegistry.PubRelMarker) {
            buff.put((byte)MessageType.PUB_REL_MARKER.ordinal());
        } else {
            throw new IllegalArgumentException("Unrecognized message class " + obj.getClass());
        }
    }

    private void writeMessageExpiry(ByteBuffer buff, Instant messageExpiry) {
        this.writeString(buff, messageExpiry.toString());
    }

    private void writePayload(ByteBuffer target, ByteBuf source) {
        int payloadSize = source.readableBytes();
        byte[] rawBytes = new byte[payloadSize];
        source.getBytes(source.readerIndex(), rawBytes);
        Utils.release(source, "persisted queue payload");
        target.putInt(payloadSize);
        target.put(rawBytes);
    }

    private void writeTopic(ByteBuffer buff, String topic) {
        this.writeString(buff, topic);
    }

    private void writeString(ByteBuffer buff, String value) {
        byte[] topicBytes = value.getBytes(StandardCharsets.UTF_8);
        buff.putInt(topicBytes.length).put(topicBytes);
    }

    private void writeProperties(ByteBuffer dest, MqttProperties.MqttProperty[] properties) {
        dest.putInt(properties.length);
        for (MqttProperties.MqttProperty property : properties) {
            this.writeProperty(dest, property);
        }
    }

    private void writeProperty(ByteBuffer dest, MqttProperties.MqttProperty property) {
        if (property instanceof MqttProperties.StringProperty) {
            MqttProperties.StringProperty stringProp = (MqttProperties.StringProperty)property;
            SegmentedPersistentQueueSerDes.writePropertyType(dest, PropertyDataType.MqttPropertyEnum.STRING);
            dest.putInt(stringProp.propertyId());
            this.writeString(dest, (String)stringProp.value());
        } else if (property instanceof MqttProperties.IntegerProperty) {
            MqttProperties.IntegerProperty intProp = (MqttProperties.IntegerProperty)property;
            SegmentedPersistentQueueSerDes.writePropertyType(dest, PropertyDataType.MqttPropertyEnum.INTEGER);
            dest.putInt(intProp.propertyId());
            dest.putInt((Integer)intProp.value());
        } else if (property instanceof MqttProperties.BinaryProperty) {
            MqttProperties.BinaryProperty byteArrayProp = (MqttProperties.BinaryProperty)property;
            SegmentedPersistentQueueSerDes.writePropertyType(dest, PropertyDataType.MqttPropertyEnum.BINARY);
            this.writeByteArray(dest, (byte[])byteArrayProp.value());
        }
    }

    private void writeByteArray(ByteBuffer dest, byte[] payload) {
        dest.putInt(payload.length);
        dest.put(payload);
    }

    private static void writePropertyType(ByteBuffer dest, PropertyDataType.MqttPropertyEnum mqttPropertyEnum) {
        dest.put((byte)mqttPropertyEnum.ordinal());
    }

    private int getMemory(SessionRegistry.EnqueuedMessage obj) {
        if (obj instanceof SessionRegistry.PubRelMarker) {
            return 1;
        }
        SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
        int propertiesSize = EnqueuedMessageValueType.hasProperties(casted) ? this.propertiesMemorySize(casted.getMqttProperties()) : 0;
        return 2 + this.topicMemorySize(casted.getTopic()) + this.messageExpirySize(casted.getMessageExpiry()) + this.payloadMemorySize(casted.getPayload()) + 1 + propertiesSize;
    }

    private int payloadMemorySize(ByteBuf payload) {
        return 4 + payload.readableBytes();
    }

    private int topicMemorySize(Topic topic) {
        return 4 + topic.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    private int messageExpirySize(Instant messageExpiry) {
        return 4 + messageExpiry.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    private int propertiesMemorySize(MqttProperties.MqttProperty[] properties) {
        return 4 + Arrays.stream(properties).mapToInt(SegmentedPersistentQueueSerDes::propertyMemorySize).sum();
    }

    private static int propertyMemorySize(MqttProperties.MqttProperty property) {
        int propSize = 4;
        if (property instanceof MqttProperties.StringProperty) {
            MqttProperties.StringProperty stringProp = (MqttProperties.StringProperty)property;
            propSize += SegmentedPersistentQueueSerDes.stringMemorySize((String)stringProp.value());
        } else if (property instanceof MqttProperties.IntegerProperty) {
            propSize += 4;
        } else if (property instanceof MqttProperties.BinaryProperty) {
            MqttProperties.BinaryProperty byteArrayProp = (MqttProperties.BinaryProperty)property;
            propSize += SegmentedPersistentQueueSerDes.byteArrayMemorySize((byte[])byteArrayProp.value());
        }
        return 1 + propSize;
    }

    private static int stringMemorySize(String value) {
        return 4 + value.getBytes(StandardCharsets.UTF_8).length;
    }

    private static int byteArrayMemorySize(byte[] payload) {
        return 4 + payload.length;
    }

    public SessionRegistry.EnqueuedMessage fromBytes(ByteBuffer buff) {
        byte messageType = buff.get();
        if (messageType == MessageType.PUB_REL_MARKER.ordinal()) {
            return new SessionRegistry.PubRelMarker();
        }
        if (messageType == MessageType.PUBLISHED_MESSAGE.ordinal()) {
            MqttQoS qos = MqttQoS.valueOf((int)buff.get());
            String topicStr = this.readTopic(buff);
            Instant messageExpiry = this.readExpiry(buff);
            ByteBuf payload = this.readPayload(buff);
            if (SerdesUtils.containsProperties(buff)) {
                MqttProperties.MqttProperty[] mqttProperties = this.readProperties(buff);
                return new SessionRegistry.PublishedMessage(Topic.asTopic(topicStr), qos, payload, false, messageExpiry, mqttProperties);
            }
            return new SessionRegistry.PublishedMessage(Topic.asTopic(topicStr), qos, payload, false, messageExpiry, new MqttProperties.MqttProperty[0]);
        }
        throw new IllegalArgumentException("Can't recognize record of type: " + messageType);
    }

    private MqttProperties.MqttProperty[] readProperties(ByteBuffer buff) {
        return SerdesUtils.readProperties(buff, buffer -> this.readProperty(buff));
    }

    private MqttProperties.MqttProperty readProperty(ByteBuffer buff) {
        return SerdesUtils.readSingleProperty(buff, this::readByteArray);
    }

    private String readTopic(ByteBuffer buff) {
        return SegmentedPersistentQueueSerDes.readString(buff);
    }

    private static String readString(ByteBuffer buff) {
        int stringLen = buff.getInt();
        byte[] rawString = new byte[stringLen];
        buff.get(rawString);
        return new String(rawString, StandardCharsets.UTF_8);
    }

    private Instant readExpiry(ByteBuffer buff) {
        String expiryText = SegmentedPersistentQueueSerDes.readString(buff);
        if (Instant.MAX.toString().equals(expiryText)) {
            return Instant.MAX;
        }
        return Instant.parse(expiryText);
    }

    private ByteBuf readPayload(ByteBuffer buff) {
        return Unpooled.wrappedBuffer((byte[])this.readByteArray(buff));
    }

    private byte[] readByteArray(ByteBuffer buff) {
        int payloadSize = buff.getInt();
        byte[] payload = new byte[payloadSize];
        buff.get(payload);
        return payload;
    }

    private static enum MessageType {
        PUB_REL_MARKER,
        PUBLISHED_MESSAGE;

    }
}

