/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthorityCache
implements IAuthorCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthorityCache.class);
    private final IoTDBDescriptor conf = IoTDBDescriptor.getInstance();
    private final Cache<String, User> userCache = Caffeine.newBuilder().maximumSize((long)this.conf.getConfig().getAuthorCacheSize()).expireAfterAccess((long)this.conf.getConfig().getAuthorCacheExpireTime(), TimeUnit.MINUTES).build();
    private final Cache<String, Role> roleCache = Caffeine.newBuilder().maximumSize((long)this.conf.getConfig().getAuthorCacheSize()).expireAfterAccess((long)this.conf.getConfig().getAuthorCacheExpireTime(), TimeUnit.MINUTES).build();

    @Override
    public User getUserCache(String userName) {
        return (User)this.userCache.getIfPresent((Object)userName);
    }

    @Override
    public Role getRoleCache(String roleName) {
        return (Role)this.roleCache.getIfPresent((Object)roleName);
    }

    @Override
    public void putUserCache(String userName, User user) {
        this.userCache.put((Object)userName, (Object)user);
    }

    @Override
    public void putRoleCache(String roleName, Role role) {
        this.roleCache.put((Object)roleName, (Object)role);
    }

    @Override
    public boolean invalidateCache(String userName, String roleName) {
        if (userName != null) {
            if (this.userCache.getIfPresent((Object)userName) != null) {
                Set roleSet = ((User)this.userCache.getIfPresent((Object)userName)).getRoleSet();
                if (!roleSet.isEmpty()) {
                    this.roleCache.invalidateAll((Iterable)roleSet);
                }
                this.userCache.invalidate((Object)userName);
            }
            if (this.userCache.getIfPresent((Object)userName) != null) {
                LOGGER.error("datanode cache initialization failed");
                return false;
            }
        }
        if (roleName != null) {
            if (this.roleCache.getIfPresent((Object)roleName) != null) {
                this.roleCache.invalidate((Object)roleName);
            }
            if (this.roleCache.getIfPresent((Object)roleName) != null) {
                LOGGER.error("datanode cache initialization failed");
                return false;
            }
        }
        return true;
    }

    @Override
    public void invalidAllCache() {
        this.userCache.invalidateAll();
        this.roleCache.invalidateAll();
    }
}

