/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.overview;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.source.dataregion.IoTDBDataRegionSource;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileToTabletsMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileToTabletsMetrics.class);
    private volatile AbstractMetricService metricService;
    private final ConcurrentSkipListSet<String> pipe = new ConcurrentSkipListSet();
    private final Map<String, Timer> pipeTimerMap = new ConcurrentHashMap<String, Timer>();
    private final Map<String, Rate> pipeRateMap = new ConcurrentHashMap<String, Rate>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.pipe).forEach(this::createMetrics);
    }

    private void createMetrics(String pipeID) {
        this.pipeTimerMap.putIfAbsent(pipeID, this.metricService.getOrCreateTimer(Metric.PIPE_TSFILE_TO_TABLETS_TIME.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), pipeID}));
        this.pipeRateMap.putIfAbsent(pipeID, this.metricService.getOrCreateRate(Metric.PIPE_TSFILE_TO_TABLETS_RATE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), pipeID}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.pipe).forEach(this::deregister);
        if (!this.pipe.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe tsfile to tablets metrics, pipe map is not empty, pipe: {}", this.pipe);
        }
    }

    private void removeMetrics(String pipeID) {
        this.metricService.remove(MetricType.TIMER, Metric.PIPE_TSFILE_TO_TABLETS_TIME.toString(), new String[]{Tag.NAME.toString(), pipeID});
        this.pipeTimerMap.remove(pipeID);
        this.metricService.remove(MetricType.RATE, Metric.PIPE_TSFILE_TO_TABLETS_RATE.toString(), new String[]{Tag.NAME.toString(), pipeID});
        this.pipeRateMap.remove(pipeID);
    }

    public void register(IoTDBDataRegionSource extractor) {
        String pipeID = extractor.getPipeName() + "_" + extractor.getCreationTime();
        this.pipe.add(pipeID);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(pipeID);
        }
    }

    public void deregister(String pipeID) {
        if (!this.pipe.contains(pipeID)) {
            LOGGER.warn("Failed to deregister pipe tsfile to tablets metrics, pipeID({}) does not exist", (Object)pipeID);
            return;
        }
        try {
            if (Objects.nonNull(this.metricService)) {
                this.removeMetrics(pipeID);
            }
        }
        finally {
            this.pipe.remove(pipeID);
        }
    }

    public void markTsFileToTabletInvocation(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.pipeRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe tsfile to tablets invocation, pipeID({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void recordTsFileToTabletTime(String taskID, long costTimeInNanos) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Timer timer = this.pipeTimerMap.get(taskID);
        if (timer == null) {
            LOGGER.info("Failed to record pipe tsfile to tablets time, pipeID({}) does not exist", (Object)taskID);
            return;
        }
        timer.updateNanos(costTimeInNanos);
    }

    public static PipeTsFileToTabletsMetrics getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final PipeTsFileToTabletsMetrics INSTANCE = new PipeTsFileToTabletsMetrics();

        private Holder() {
        }
    }
}

