/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling.sdt;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.event.common.row.PipeRemarkableRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.processor.downsampling.DownSamplingProcessor;
import org.apache.iotdb.db.pipe.processor.downsampling.PartialPathLastObjectCache;
import org.apache.iotdb.db.pipe.processor.downsampling.sdt.SwingingDoorTrendingFilter;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
public class SwingingDoorTrendingSamplingProcessor
extends DownSamplingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwingingDoorTrendingSamplingProcessor.class);
    private double compressionDeviation;
    private long compressionMinTimeInterval;
    private long compressionMaxTimeInterval;
    private PartialPathLastObjectCache<SwingingDoorTrendingFilter<?>> pathLastObjectCache;

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        PipeParameters parameters = validator.getParameters();
        this.compressionDeviation = parameters.getDoubleOrDefault("processor.sdt.compression-deviation", 0.0);
        this.compressionMinTimeInterval = parameters.getLongOrDefault("processor.sdt.min-time-interval", 0L);
        this.compressionMaxTimeInterval = parameters.getLongOrDefault("processor.sdt.max-time-interval", Long.MAX_VALUE);
        validator.validate(compressionDeviation -> (Double)compressionDeviation >= 0.0, String.format("%s must be >= 0, but got %s", "processor.sdt.compression-deviation", this.compressionDeviation), (Object)this.compressionDeviation).validate(compressionMinTimeInterval -> (Long)compressionMinTimeInterval >= 0L, String.format("%s must be >= 0, but got %s", "processor.sdt.min-time-interval", this.compressionMinTimeInterval), (Object)this.compressionMinTimeInterval).validate(compressionMaxTimeInterval -> (Long)compressionMaxTimeInterval >= 0L, String.format("%s must be >= 0, but got %s", "processor.sdt.max-time-interval", this.compressionMaxTimeInterval), (Object)this.compressionMaxTimeInterval).validate(minMaxPair -> (Long)minMaxPair[0] <= (Long)minMaxPair[1], String.format("%s must be <= %s, but got %s and %s", "processor.sdt.min-time-interval", "processor.sdt.max-time-interval", this.compressionMinTimeInterval, this.compressionMaxTimeInterval), new Object[]{this.compressionMinTimeInterval, this.compressionMaxTimeInterval});
    }

    @Override
    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) {
        super.customize(parameters, configuration);
        LOGGER.info("SwingingDoorTrendingSamplingProcessor in {} is initialized with {}: {}, {}: {}, {}: {}.", new Object[]{this.dataBaseNameWithPathSeparator, "processor.sdt.compression-deviation", this.compressionDeviation, "processor.sdt.min-time-interval", this.compressionMinTimeInterval, "processor.sdt.max-time-interval", this.compressionMaxTimeInterval});
    }

    @Override
    protected PartialPathLastObjectCache<?> initPathLastObjectCache(long memoryLimitInBytes) {
        this.pathLastObjectCache = new PartialPathLastObjectCache<SwingingDoorTrendingFilter<?>>(memoryLimitInBytes){

            @Override
            protected long calculateMemoryUsage(SwingingDoorTrendingFilter<?> object) {
                return 64L;
            }
        };
        return this.pathLastObjectCache;
    }

    @Override
    protected void processRow(Row row, RowCollector rowCollector, String deviceSuffix, AtomicReference<Exception> exception) {
        PipeRemarkableRow remarkableRow = new PipeRemarkableRow((PipeRow)row);
        boolean hasNonNullMeasurements = false;
        int size = row.size();
        for (int i = 0; i < size; ++i) {
            if (row.isNull(i)) continue;
            String timeSeriesSuffix = deviceSuffix + "." + row.getColumnName(i);
            SwingingDoorTrendingFilter<?> filter = this.pathLastObjectCache.getPartialPathLastObject(timeSeriesSuffix);
            if (filter != null) {
                if (filter.filter(row.getTime(), row.getObject(i))) {
                    hasNonNullMeasurements = true;
                    continue;
                }
                remarkableRow.markNull(i);
                continue;
            }
            hasNonNullMeasurements = true;
            this.pathLastObjectCache.setPartialPathLastObject(timeSeriesSuffix, new SwingingDoorTrendingFilter<Object>(this, row.getTime(), row.getObject(i)));
        }
        if (hasNonNullMeasurements) {
            try {
                rowCollector.collectRow((Row)remarkableRow);
            }
            catch (IOException e) {
                exception.set(e);
            }
        }
    }

    double getCompressionDeviation() {
        return this.compressionDeviation;
    }

    long getCompressionMinTimeInterval() {
        return this.compressionMinTimeInterval;
    }

    long getCompressionMaxTimeInterval() {
        return this.compressionMaxTimeInterval;
    }
}

