/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeReceiver;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus.PipeConsensusReceiver;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusReceiverAgent
implements ConsensusPipeReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusReceiverAgent.class);
    private static final Map<Byte, TriFunction<PipeConsensus, ConsensusGroupId, ConsensusPipeName, PipeConsensusReceiver>> RECEIVER_CONSTRUCTORS = new HashMap<Byte, TriFunction<PipeConsensus, ConsensusGroupId, ConsensusPipeName, PipeConsensusReceiver>>();
    private static final long WAIT_INITIALIZE_RECEIVER_INTERVAL_IN_MS = 100L;
    private final int thisNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private final Map<ConsensusGroupId, Map<ConsensusPipeName, AtomicReference<PipeConsensusReceiver>>> replicaReceiverMap = new ConcurrentHashMap<ConsensusGroupId, Map<ConsensusPipeName, AtomicReference<PipeConsensusReceiver>>>();
    private final ReentrantReadWriteLock receiverLifeCircleLock = new ReentrantReadWriteLock();
    private final Set<Integer> staleRegions = new CopyOnWriteArraySet<Integer>();
    private PipeConsensus pipeConsensus;

    public PipeConsensusReceiverAgent() {
        RECEIVER_CONSTRUCTORS.put(PipeConsensusRequestVersion.VERSION_1.getVersion(), (TriFunction<PipeConsensus, ConsensusGroupId, ConsensusPipeName, PipeConsensusReceiver>)((TriFunction)PipeConsensusReceiver::new));
    }

    public void initConsensusInRuntime() {
        IConsensus consensus = DataRegionConsensusImpl.getInstance();
        this.pipeConsensus = consensus instanceof PipeConsensus ? (PipeConsensus)consensus : null;
    }

    public static TPipeConsensusTransferResp closedResp(String consensusInfo, TCommitId tCommitId) {
        TSStatus status = new TSStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_CLOSE_ERROR, (String)"PipeConsensus receiver received a request after it was closed."));
        LOGGER.info("PipeConsensus-{}: receive on-the-fly no.{} event after data region was deleted, discard it", (Object)consensusInfo, (Object)tCommitId);
        return new TPipeConsensusTransferResp(status);
    }

    public TPipeConsensusTransferResp receive(TPipeConsensusTransferReq req) {
        byte reqVersion = req.getVersion();
        if (RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) {
            ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
            PipeConsensusReceiver receiver = this.getReceiver(consensusGroupId, req.getDataNodeId(), reqVersion);
            if (receiver == null) {
                return PipeConsensusReceiverAgent.closedResp(consensusGroupId.toString(), req.getCommitId());
            }
            return receiver.receive(req);
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_VERSION_ERROR, (String)String.format("Unknown PipeConsensusRequestVersion %s.", reqVersion));
        LOGGER.warn("PipeConsensus: Unknown PipeConsensusRequestVersion, response status = {}.", (Object)status);
        return new TPipeConsensusTransferResp(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PipeConsensusReceiver getReceiver(ConsensusGroupId consensusGroupId, int leaderDataNodeId, byte reqVersion) {
        this.receiverLifeCircleLock.readLock().lock();
        try {
            AtomicBoolean isFirstGetReceiver;
            ConsensusPipeName consensusPipeName;
            if (this.staleRegions.contains(consensusGroupId.getId())) {
                PipeConsensusReceiver pipeConsensusReceiver = null;
                return pipeConsensusReceiver;
            }
            Map consensusPipe2ReceiverMap = this.replicaReceiverMap.computeIfAbsent(consensusGroupId, key -> new ConcurrentHashMap());
            AtomicReference receiverReference = consensusPipe2ReceiverMap.computeIfAbsent(consensusPipeName = new ConsensusPipeName(consensusGroupId, leaderDataNodeId, this.thisNodeId), arg_0 -> PipeConsensusReceiverAgent.lambda$getReceiver$1(isFirstGetReceiver = new AtomicBoolean(false), arg_0));
            if (receiverReference.get() == null) {
                PipeConsensusReceiver pipeConsensusReceiver = this.internalSetAndGetReceiver(consensusGroupId, consensusPipeName, reqVersion, isFirstGetReceiver);
                return pipeConsensusReceiver;
            }
            byte receiverThreadLocalVersion = ((PipeConsensusReceiver)receiverReference.get()).getVersion().getVersion();
            if (receiverThreadLocalVersion != reqVersion) {
                LOGGER.warn("The pipeConsensus request version {} is different from the sender request version {}, the receiver will be reset to the sender request version.", (Object)receiverThreadLocalVersion, (Object)reqVersion);
                receiverReference.set(null);
                PipeConsensusReceiver pipeConsensusReceiver = this.internalSetAndGetReceiver(consensusGroupId, consensusPipeName, reqVersion, isFirstGetReceiver);
                return pipeConsensusReceiver;
            }
            PipeConsensusReceiver pipeConsensusReceiver = (PipeConsensusReceiver)receiverReference.get();
            return pipeConsensusReceiver;
        }
        finally {
            this.receiverLifeCircleLock.readLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PipeConsensusReceiver internalSetAndGetReceiver(ConsensusGroupId consensusGroupId, ConsensusPipeName consensusPipeName, byte reqVersion, AtomicBoolean isFirstGetReceiver) {
        Map<ConsensusPipeName, AtomicReference<PipeConsensusReceiver>> consensusPipe2ReciverMap = this.replicaReceiverMap.get(consensusGroupId);
        AtomicReference<PipeConsensusReceiver> receiverReference = consensusPipe2ReciverMap.get(consensusPipeName);
        if (isFirstGetReceiver.get()) {
            if (!RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) throw new UnsupportedOperationException(String.format("Unsupported pipeConsensus request version %d", reqVersion));
            receiverReference.set((PipeConsensusReceiver)RECEIVER_CONSTRUCTORS.get(reqVersion).apply((Object)this.pipeConsensus, (Object)consensusGroupId, (Object)consensusPipeName));
            LOGGER.info("Receiver-{} is ready", (Object)consensusPipeName);
            return receiverReference.get();
        } else {
            this.waitUntilReceiverGetInitiated(receiverReference);
        }
        return receiverReference.get();
    }

    private void waitUntilReceiverGetInitiated(AtomicReference<PipeConsensusReceiver> receiverReference) {
        try {
            while (receiverReference.get() == null) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("PipeConsensusReceiver thread is interrupted when waiting for receiver get initiated, may because system exit.", (Throwable)e);
        }
    }

    public final void releaseReceiverResource(DataRegionId dataRegionId) {
        this.receiverLifeCircleLock.writeLock().lock();
        try {
            this.staleRegions.add(dataRegionId.getId());
            Map consensusPipe2ReciverMap = this.replicaReceiverMap.getOrDefault(ConsensusGroupId.Factory.create((int)TConsensusGroupType.DataRegion.getValue(), (int)dataRegionId.getId()), new ConcurrentHashMap());
            consensusPipe2ReciverMap.entrySet().stream().filter(entry -> ((ConsensusPipeName)entry.getKey()).getReceiverDataNodeId() == this.thisNodeId).forEach(receiverEntry -> {
                ConsensusPipeName consensusPipeName = (ConsensusPipeName)receiverEntry.getKey();
                AtomicReference receiverReference = (AtomicReference)receiverEntry.getValue();
                if (receiverReference != null) {
                    ((PipeConsensusReceiver)receiverReference.get()).handleExit();
                    receiverReference.set(null);
                }
            });
            this.replicaReceiverMap.remove(dataRegionId);
            consensusPipe2ReciverMap.clear();
            LOGGER.info("All Receivers related to {} are released.", (Object)dataRegionId);
        }
        finally {
            this.receiverLifeCircleLock.writeLock().unlock();
        }
    }

    public final void closeReceiverExecutor() {
        this.replicaReceiverMap.forEach((consensusGroupId, receiverMap) -> receiverMap.forEach((consensusPipeName, receiverReference) -> {
            if (receiverReference != null) {
                ((PipeConsensusReceiver)receiverReference.get()).closeExecutor();
                LOGGER.info("Receivers-{}' executor is closed.", consensusPipeName);
            }
        }));
    }

    private static /* synthetic */ AtomicReference lambda$getReceiver$1(AtomicBoolean isFirstGetReceiver, ConsensusPipeName key) {
        isFirstGetReceiver.set(true);
        return new AtomicReference<Object>(null);
    }
}

