/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFilePublicResource
extends PipeTsFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFilePublicResource.class);
    public static final float MEMORY_SUFFICIENT_THRESHOLD = 0.7f;
    private PipeMemoryBlock allocatedMemoryBlock;
    private Map<IDeviceID, List<String>> deviceMeasurementsMap = null;
    private Map<IDeviceID, Boolean> deviceIsAlignedMap = null;
    private Map<String, TSDataType> measurementDataTypeMap = null;

    public PipeTsFilePublicResource(File hardlinkOrCopiedFile) {
        super(hardlinkOrCopiedFile);
    }

    @Override
    public void close() {
        super.close();
        if (this.deviceMeasurementsMap != null) {
            this.deviceMeasurementsMap = null;
        }
        if (this.deviceIsAlignedMap != null) {
            this.deviceIsAlignedMap = null;
        }
        if (this.measurementDataTypeMap != null) {
            this.measurementDataTypeMap = null;
        }
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
            this.allocatedMemoryBlock = null;
        }
    }

    public synchronized Map<IDeviceID, List<String>> tryGetDeviceMeasurementsMap(File tsFile) throws IOException {
        if (this.deviceMeasurementsMap == null) {
            this.cacheObjectsIfAbsent(tsFile);
        }
        return this.deviceMeasurementsMap;
    }

    public synchronized Map<IDeviceID, Boolean> tryGetDeviceIsAlignedMap(boolean cacheOtherMetadata, File tsFile) throws IOException {
        if (this.deviceIsAlignedMap == null) {
            if (cacheOtherMetadata) {
                this.cacheObjectsIfAbsent(tsFile);
            } else {
                this.cacheDeviceIsAlignedMapIfAbsent(tsFile);
            }
        }
        return this.deviceIsAlignedMap;
    }

    public synchronized Map<String, TSDataType> tryGetMeasurementDataTypeMap(File tsFile) throws IOException {
        if (this.measurementDataTypeMap == null) {
            this.cacheObjectsIfAbsent(tsFile);
        }
        return this.measurementDataTypeMap;
    }

    synchronized boolean cacheDeviceIsAlignedMapIfAbsent(File tsFile) throws IOException {
        if (this.allocatedMemoryBlock != null) {
            return true;
        }
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes(), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("Failed to cacheDeviceIsAlignedMapIfAbsent for tsfile {}, because memory usage is high", (Object)tsFile.getPath());
            return false;
        }
        long memoryRequiredInBytes = 0L;
        try (TsFileSequenceReader sequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, false);){
            this.deviceIsAlignedMap = new HashMap<IDeviceID, Boolean>();
            TsFileDeviceIterator deviceIsAlignedIterator = sequenceReader.getAllDevicesIteratorWithIsAligned();
            while (deviceIsAlignedIterator.hasNext()) {
                Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
                this.deviceIsAlignedMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
            }
        }
        this.allocatedMemoryBlock.close();
        this.allocatedMemoryBlock = null;
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("PipeTsFileResource: Failed to cache objects for tsfile {} in cache, because memory usage is high", (Object)tsFile.getPath());
            this.deviceIsAlignedMap = null;
            return false;
        }
        LOGGER.info("PipeTsFileResource: Cached deviceIsAlignedMap for tsfile {}.", (Object)tsFile.getPath());
        return true;
    }

    synchronized boolean cacheObjectsIfAbsent(File tsFile) throws IOException {
        if (this.allocatedMemoryBlock != null) {
            if (this.deviceMeasurementsMap != null) {
                return true;
            }
            this.allocatedMemoryBlock.close();
            this.allocatedMemoryBlock = null;
        }
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes(), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("Failed to cacheObjectsIfAbsent for tsfile {}, because memory usage is high", (Object)tsFile.getPath());
            return false;
        }
        long memoryRequiredInBytes = 0L;
        try (TsFileSequenceReader sequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);){
            this.deviceMeasurementsMap = sequenceReader.getDeviceMeasurementsMap();
            memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceID2StrList(this.deviceMeasurementsMap);
            if (Objects.isNull(this.deviceIsAlignedMap)) {
                this.deviceIsAlignedMap = new HashMap<IDeviceID, Boolean>();
                TsFileDeviceIterator deviceIsAlignedIterator = sequenceReader.getAllDevicesIteratorWithIsAligned();
                while (deviceIsAlignedIterator.hasNext()) {
                    Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
                    this.deviceIsAlignedMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
                }
            }
            memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap);
            this.measurementDataTypeMap = sequenceReader.getFullPathDataTypeMap();
        }
        this.allocatedMemoryBlock.close();
        this.allocatedMemoryBlock = null;
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfStr2TSDataType(this.measurementDataTypeMap), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("PipeTsFileResource: Failed to cache objects for tsfile {} in cache, because memory usage is high", (Object)tsFile.getPath());
            this.deviceIsAlignedMap = null;
            this.deviceMeasurementsMap = null;
            this.measurementDataTypeMap = null;
            return false;
        }
        LOGGER.info("PipeTsFileResource: Cached objects for tsfile {}.", (Object)tsFile.getPath());
        return true;
    }
}

