/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner.PipeTsFileEpochProgressIndexKeeper;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionTsFileSource
extends PipeRealtimeDataRegionSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionTsFileSource.class);

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        if (event.getEvent() instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
            return;
        }
        if (event.getEvent() instanceof PipeDeleteDataNodeEvent) {
            this.extractDirectly(event);
            return;
        }
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
        PipeTsFileEpochProgressIndexKeeper.getInstance().registerProgressIndex(this.dataRegionId, this.pipeName, event.getTsFileEpoch().getResource());
        if (!(event.getEvent() instanceof TsFileInsertionEvent)) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionTsFileSource.class.getName(), false);
            return;
        }
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionTsFileExtractor %s has reached capacity, discard TsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionTsFileSource.class.getName(), false);
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return this.shouldExtractInsertion;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return false;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent = null;
            if (realtimeEvent.getEvent() instanceof PipeHeartbeatEvent) {
                suppliedEvent = this.supplyHeartbeat(realtimeEvent);
            } else if (realtimeEvent.getEvent() instanceof PipeDeleteDataNodeEvent || realtimeEvent.getEvent() instanceof ProgressReportEvent) {
                suppliedEvent = this.supplyDirectly(realtimeEvent);
            } else if (realtimeEvent.increaseReferenceCount(PipeRealtimeDataRegionTsFileSource.class.getName())) {
                suppliedEvent = realtimeEvent.getEvent();
            } else {
                String errorMessage = String.format("Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", realtimeEvent.getEvent());
                LOGGER.error(errorMessage);
                PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                PipeTsFileEpochProgressIndexKeeper.getInstance().eliminateProgressIndex(this.dataRegionId, this.pipeName, realtimeEvent.getTsFileEpoch().getFilePath());
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionTsFileSource.class.getName(), false);
            if (suppliedEvent != null) {
                this.maySkipIndex4Event(realtimeEvent);
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }
}

