/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;

public class ResultNodeContext {
    private final FragmentInstanceId virtualFragmentInstanceId;
    private final PlanNodeId virtualResultNodeId;
    private TEndPoint upStreamEndpoint;
    private FragmentInstanceId upStreamFragmentInstanceId;
    private PlanNodeId upStreamPlanNodeId;

    public ResultNodeContext(QueryId queryId) {
        this.virtualResultNodeId = queryId.genPlanNodeId();
        this.virtualFragmentInstanceId = queryId.genPlanFragmentId().genFragmentInstanceId();
    }

    public void setUpStream(TEndPoint upStreamEndpoint, FragmentInstanceId upStreamFragmentInstanceId, PlanNodeId upStreamPlanNodeId) {
        this.upStreamEndpoint = upStreamEndpoint;
        this.upStreamFragmentInstanceId = upStreamFragmentInstanceId;
        this.upStreamPlanNodeId = upStreamPlanNodeId;
    }

    public FragmentInstanceId getVirtualFragmentInstanceId() {
        return this.virtualFragmentInstanceId;
    }

    public PlanNodeId getVirtualResultNodeId() {
        return this.virtualResultNodeId;
    }

    public TEndPoint getUpStreamEndpoint() {
        return this.upStreamEndpoint;
    }

    public FragmentInstanceId getUpStreamFragmentInstanceId() {
        return this.upStreamFragmentInstanceId;
    }

    public PlanNodeId getUpStreamPlanNodeId() {
        return this.upStreamPlanNodeId;
    }
}

