/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class EnforceSingleRowOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(EnforceSingleRowOperator.class);
    private static final String MULTIPLE_ROWS_ERROR_MESSAGE = "Scalar sub-query has returned multiple rows.";
    private static final String NO_RESULT_ERROR_MESSAGE = "Scalar sub-query does not have output.";
    private final OperatorContext operatorContext;
    private final Operator child;
    private boolean finished = false;

    public EnforceSingleRowOperator(OperatorContext operatorContext, Operator child) {
        this.operatorContext = operatorContext;
        this.child = child;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock tsBlock = this.child.nextWithTimer();
        if (tsBlock == null || tsBlock.isEmpty()) {
            return tsBlock;
        }
        if (tsBlock.getPositionCount() > 1 || this.finished) {
            throw new SemanticException(MULTIPLE_ROWS_ERROR_MESSAGE);
        }
        this.finished = true;
        return tsBlock;
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.isFinished();
    }

    @Override
    public void close() throws Exception {
        if (this.child != null) {
            this.child.close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        boolean childFinished = this.child.isFinished();
        if (childFinished && !this.finished) {
            throw new SemanticException(NO_RESULT_ERROR_MESSAGE);
        }
        return childFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize() / (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }
}

