/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.aggregation.TreeAggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.SingleInputAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowManagerFactory;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowParameter;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.RamUsageEstimator;

public class RawDataAggregationOperator
extends SingleInputAggregationOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(RawDataAggregationOperator.class);
    private final IWindowManager windowManager;
    private boolean needSkip = false;
    private boolean hasCachedDataInAggregator = false;

    public RawDataAggregationOperator(OperatorContext operatorContext, List<TreeAggregator> aggregators, ITimeRangeIterator timeRangeIterator, Operator child, boolean ascending, long maxReturnSize, WindowParameter windowParameter) {
        super(operatorContext, aggregators, child, ascending, maxReturnSize);
        this.windowManager = WindowManagerFactory.genWindowManager(windowParameter, timeRangeIterator, ascending);
        this.resultTsBlockBuilder = this.windowManager.createResultTsBlockBuilder(aggregators);
    }

    private boolean hasMoreData() throws Exception {
        return this.inputTsBlock != null && !this.inputTsBlock.isEmpty() || this.child.hasNextWithTimer() || this.hasCachedDataInAggregator;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.windowManager.hasNext(this.hasMoreData());
    }

    @Override
    protected boolean calculateNextAggregationResult() throws Exception {
        while (this.needSkip || !this.calculateFromRawData()) {
            this.inputTsBlock = null;
            if (this.child.hasNextWithTimer() && this.canCallNext) {
                this.inputTsBlock = this.child.nextWithTimer();
                this.canCallNext = false;
                if (!this.needSkip) continue;
                break;
            }
            if (this.child.hasNextWithTimer()) {
                return false;
            }
            if (this.windowManager.notInitializedLastTimeWindow()) {
                this.initWindowAndAggregators();
            }
            if (this.needSkip || this.windowManager.isCurWindowInit()) break;
            return false;
        }
        if (!this.needSkip) {
            this.windowManager.next();
        }
        if (this.windowManager.needSkipInAdvance()) {
            this.needSkip = true;
            this.inputTsBlock = this.windowManager.skipPointsOutOfCurWindow(this.inputTsBlock);
            if ((this.inputTsBlock == null || this.inputTsBlock.isEmpty()) && this.child.hasNextWithTimer()) {
                return this.canCallNext;
            }
            this.needSkip = false;
        }
        this.updateResultTsBlock();
        this.hasCachedDataInAggregator = false;
        return true;
    }

    private boolean calculateFromRawData() {
        if (!this.windowManager.isCurWindowInit() && !this.skipPreviousWindowAndInitCurWindow()) {
            return false;
        }
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return false;
        }
        if (this.windowManager.satisfiedCurWindow(this.inputTsBlock)) {
            int tsBlockSize = this.inputTsBlock.getPositionCount();
            IWindow curWindow = this.windowManager.getCurWindow();
            Column[] controlAndTimeColumn = new Column[]{curWindow.getControlColumn(this.inputTsBlock), this.inputTsBlock.getTimeColumn()};
            BitMap needProcess = new BitMap(tsBlockSize);
            int lastIndexToProcess = -1;
            boolean hasSkip = false;
            for (int i = 0; i < tsBlockSize; ++i) {
                if (this.windowManager.isIgnoringNull() && controlAndTimeColumn[0].isNull(i)) {
                    lastIndexToProcess = i;
                    hasSkip = true;
                    continue;
                }
                if (!curWindow.satisfy(controlAndTimeColumn[0], i)) break;
                needProcess.mark(i);
                curWindow.mergeOnePoint(controlAndTimeColumn, i);
                lastIndexToProcess = i;
            }
            if (!hasSkip) {
                needProcess = null;
            }
            TsBlock inputRegion = this.inputTsBlock.getRegion(0, lastIndexToProcess + 1);
            for (TreeAggregator aggregator : this.aggregators) {
                if (aggregator.hasFinalResult()) continue;
                aggregator.processTsBlock(inputRegion, needProcess);
            }
            int lastReadRowIndex = lastIndexToProcess + 1;
            if (lastReadRowIndex != 0) {
                this.hasCachedDataInAggregator = true;
            }
            if (lastReadRowIndex >= this.inputTsBlock.getPositionCount()) {
                this.inputTsBlock = null;
                return AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators);
            }
            this.inputTsBlock = this.inputTsBlock.subTsBlock(lastReadRowIndex);
            return true;
        }
        boolean isTsBlockOutOfBound = this.windowManager.isTsBlockOutOfBound(this.inputTsBlock);
        return AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || isTsBlockOutOfBound;
    }

    @Override
    protected void updateResultTsBlock() {
        this.windowManager.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + (this.resultTsBlockBuilder == null ? 0L : this.resultTsBlockBuilder.getRetainedSizeInBytes());
    }

    private boolean skipPreviousWindowAndInitCurWindow() {
        this.inputTsBlock = this.windowManager.skipPointsOutOfCurWindow(this.inputTsBlock);
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return false;
        }
        this.initWindowAndAggregators();
        return true;
    }

    private void initWindowAndAggregators() {
        this.windowManager.initCurWindow();
        for (TreeAggregator aggregator : this.aggregators) {
            aggregator.reset();
        }
    }
}

