/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastByAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;

public class LastByDescAccumulator
extends LastByAccumulator {
    public LastByDescAccumulator(TSDataType xDataType, TSDataType yDataType, boolean xIsTimeColumn, boolean yIsTimeColumn) {
        super(xDataType, yDataType, xIsTimeColumn, yIsTimeColumn);
    }

    @Override
    public TableAccumulator copy() {
        return new LastByDescAccumulator(this.xDataType, this.yDataType, this.xIsTimeColumn, this.yIsTimeColumn);
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }

    @Override
    protected void addIntInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateIntLastValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateIntLastValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addLongInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateLongLastValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateLongLastValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addFloatInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateFloatLastValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateFloatLastValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addDoubleInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateDoubleLastValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateDoubleLastValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addBinaryInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateBinaryLastValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateBinaryLastValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    @Override
    protected void addBooleanInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateBooleanLastValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateBooleanLastValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }
}

