/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BigArrays;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntBigArrays;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntComparator;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class IntBigArray {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(IntBigArray.class);
    private static final long SIZE_OF_SEGMENT = RamUsageEstimator.sizeOfIntArray((int)1024);
    private final int initialValue;
    private int[][] array;
    private long capacity;
    private int segments;

    public IntBigArray() {
        this(0);
    }

    public IntBigArray(int initialValue) {
        this.initialValue = initialValue;
        this.array = new int[1024][];
        this.allocateNewSegment();
    }

    public int[][] getSegments() {
        return this.array;
    }

    public long sizeOf() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public int get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, int value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        int[] nArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        nArray[n] = nArray[n] + 1;
    }

    public void add(long index, int value) {
        int[] nArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        nArray[n] = nArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    public void fill(int value) {
        for (int[] segment : this.array) {
            if (segment == null) {
                return;
            }
            Arrays.fill(segment, value);
        }
    }

    public void reset() {
        this.fill(this.initialValue);
    }

    public void copyTo(long sourceIndex, IntBigArray destination, long destinationIndex, long length) {
        while (length > 0L) {
            int startSegment = BigArrays.segment(sourceIndex);
            int startOffset = BigArrays.offset(sourceIndex);
            int destinationStartSegment = BigArrays.segment(destinationIndex);
            int destinationStartOffset = BigArrays.offset(destinationIndex);
            int copyLength = Math.min(1024 - startOffset, 1024 - destinationStartOffset);
            copyLength = Math.min(copyLength, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length);
            System.arraycopy(this.array[startSegment], startOffset, destination.array[destinationStartSegment], destinationStartOffset, copyLength);
            sourceIndex += (long)copyLength;
            destinationIndex += (long)copyLength;
            length -= (long)copyLength;
        }
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (int[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        int[] newSegment = new int[1024];
        if (this.initialValue != 0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }

    public void sort(int from, int to, IntComparator comparator) {
        IntBigArrays.quickSort(this.array, from, to, comparator);
    }
}

