/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDAFInformationInferrer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFInformationInferrer;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class ExpressionTypeAnalyzer {
    private final Map<NodeRef<Expression>, TSDataType> expressionTypes = new LinkedHashMap<NodeRef<Expression>, TSDataType>();

    private ExpressionTypeAnalyzer() {
    }

    public static TSDataType analyzeExpression(Analysis analysis, Expression expression) {
        if (!analysis.getExpressionTypes().containsKey(NodeRef.of(expression))) {
            ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
            TemplateTypeProvider context = analysis.allDevicesInOneTemplate() ? new TemplateTypeProvider(analysis.getDeviceTemplate().getSchemaMap()) : null;
            analyzer.analyze(expression, context);
            ExpressionTypeAnalyzer.addExpressionTypes(analysis, analyzer);
        }
        return analysis.getType(expression);
    }

    public static TSDataType analyzeExpressionForTemplatedQuery(Analysis analysis, Expression expression) {
        if (!analysis.getExpressionTypes().containsKey(NodeRef.of(expression))) {
            ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
            analyzer.analyze(expression, new TemplateTypeProvider(analysis.getDeviceTemplate().getSchemaMap()));
            ExpressionTypeAnalyzer.addExpressionTypes(analysis, analyzer);
        }
        return analysis.getType(expression);
    }

    public static void analyzeExpression(Map<NodeRef<Expression>, TSDataType> types, Expression expression) {
        ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
        analyzer.analyze(expression, null);
        types.putAll(analyzer.getExpressionTypes());
    }

    public static void analyzeExpression(Map<NodeRef<Expression>, TSDataType> types, Expression expression, Function<String, TSDataType> schemaMap) {
        ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
        analyzer.analyze(expression, schemaMap);
        types.putAll(analyzer.getExpressionTypes());
    }

    private static void addExpressionTypes(Analysis analysis, ExpressionTypeAnalyzer analyzer) {
        analysis.addTypes(analyzer.getExpressionTypes());
    }

    public TSDataType analyze(Expression expression, Function<String, TSDataType> context) {
        Visitor visitor = new Visitor();
        return visitor.process(expression, context);
    }

    public Map<NodeRef<Expression>, TSDataType> getExpressionTypes() {
        return this.expressionTypes;
    }

    private TSDataType getInputExpressionTypeForAggregation(List<Expression> inputExpressions, String aggregateFunctionName) {
        switch (aggregateFunctionName.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "min_value": 
            case "max_value": 
            case "extreme": 
            case "last_value": 
            case "first_value": 
            case "count": 
            case "avg": 
            case "sum": 
            case "count_if": 
            case "time_duration": 
            case "mode": 
            case "count_time": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": 
            case "max_by": 
            case "min_by": {
                return this.expressionTypes.get(NodeRef.of(inputExpressions.get(0)));
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggregateFunctionName);
    }

    public static class TemplateTypeProvider
    implements Function<String, TSDataType> {
        private final Map<String, IMeasurementSchema> schemaMap;

        public TemplateTypeProvider(Map<String, IMeasurementSchema> schemaMap) {
            this.schemaMap = schemaMap;
        }

        @Override
        public TSDataType apply(String s) {
            IMeasurementSchema measurementSchema = this.schemaMap.get(s);
            return measurementSchema == null ? null : measurementSchema.getType();
        }
    }

    private class Visitor
    extends ExpressionVisitor<TSDataType, Function<String, TSDataType>> {
        private Visitor() {
        }

        @Override
        public TSDataType process(Expression expression, Function<String, TSDataType> context) {
            TSDataType dataType = (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(expression));
            if (dataType != null) {
                return dataType;
            }
            return (TSDataType)super.process(expression, context);
        }

        @Override
        public TSDataType visitExpression(Expression expression, Function<String, TSDataType> context) {
            throw new UnsupportedOperationException("Unsupported expression type: " + expression.getClass().getName());
        }

        @Override
        public TSDataType visitInExpression(InExpression inExpression, Function<String, TSDataType> context) {
            this.process(inExpression.getExpression(), context);
            return this.setExpressionType(inExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitIsNullExpression(IsNullExpression isNullExpression, Function<String, TSDataType> context) {
            this.process(isNullExpression.getExpression(), context);
            return this.setExpressionType(isNullExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitLikeExpression(LikeExpression likeExpression, Function<String, TSDataType> context) {
            this.checkInputExpressionDataType(likeExpression.getExpression().getExpressionString(), this.process(likeExpression.getExpression(), context), TSDataType.TEXT, TSDataType.STRING);
            return this.setExpressionType(likeExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitRegularExpression(RegularExpression regularExpression, Function<String, TSDataType> context) {
            this.checkInputExpressionDataType(regularExpression.getExpression().getExpressionString(), this.process(regularExpression.getExpression(), context), TSDataType.TEXT, TSDataType.STRING);
            return this.setExpressionType(regularExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitLogicNotExpression(LogicNotExpression logicNotExpression, Function<String, TSDataType> context) {
            this.checkInputExpressionDataType(logicNotExpression.getExpression().getExpressionString(), this.process(logicNotExpression.getExpression(), context), TSDataType.BOOLEAN);
            return this.setExpressionType(logicNotExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitNegationExpression(NegationExpression negationExpression, Function<String, TSDataType> context) {
            TSDataType inputExpressionType = this.process(negationExpression.getExpression(), context);
            this.checkInputExpressionDataType(negationExpression.getExpression().getExpressionString(), inputExpressionType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            return this.setExpressionType(negationExpression, inputExpressionType);
        }

        @Override
        public TSDataType visitArithmeticBinaryExpression(ArithmeticBinaryExpression arithmeticBinaryExpression, Function<String, TSDataType> context) {
            this.checkInputExpressionDataType(arithmeticBinaryExpression.getLeftExpression().getExpressionString(), this.process(arithmeticBinaryExpression.getLeftExpression(), context), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            this.checkInputExpressionDataType(arithmeticBinaryExpression.getRightExpression().getExpressionString(), this.process(arithmeticBinaryExpression.getRightExpression(), context), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            if ((arithmeticBinaryExpression.getExpressionType() == ExpressionType.DIVISION || arithmeticBinaryExpression.getExpressionType() == ExpressionType.MODULO) && this.isExpressionDataTypeSatisfy(arithmeticBinaryExpression.getLeftExpression(), TSDataType.INT64, TSDataType.INT32) && this.isExpressionDataTypeSatisfy(arithmeticBinaryExpression.getRightExpression(), TSDataType.INT64, TSDataType.INT32)) {
                return this.setExpressionType(arithmeticBinaryExpression, TSDataType.INT64);
            }
            return this.setExpressionType(arithmeticBinaryExpression, TSDataType.DOUBLE);
        }

        @Override
        public TSDataType visitLogicBinaryExpression(LogicBinaryExpression logicBinaryExpression, Function<String, TSDataType> context) {
            this.checkInputExpressionDataType(logicBinaryExpression.getLeftExpression().getExpressionString(), this.process(logicBinaryExpression.getLeftExpression(), context), TSDataType.BOOLEAN);
            this.checkInputExpressionDataType(logicBinaryExpression.getRightExpression().getExpressionString(), this.process(logicBinaryExpression.getRightExpression(), context), TSDataType.BOOLEAN);
            return this.setExpressionType(logicBinaryExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitCompareBinaryExpression(CompareBinaryExpression compareBinaryExpression, Function<String, TSDataType> context) {
            TSDataType leftExpressionDataType = this.process(compareBinaryExpression.getLeftExpression(), context);
            TSDataType rightExpressionDataType = this.process(compareBinaryExpression.getRightExpression(), context);
            if (leftExpressionDataType != null && rightExpressionDataType != null && !leftExpressionDataType.equals((Object)rightExpressionDataType)) {
                String leftExpressionString = compareBinaryExpression.getLeftExpression().getExpressionString();
                String rightExpressionString = compareBinaryExpression.getRightExpression().getExpressionString();
                if (TSDataType.BOOLEAN.equals((Object)leftExpressionDataType) || TSDataType.BOOLEAN.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.BOOLEAN);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.BOOLEAN);
                } else if (TSDataType.DATE.equals((Object)leftExpressionDataType) || TSDataType.DATE.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.DATE, TSDataType.TEXT);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.DATE, TSDataType.TEXT);
                } else if (TSDataType.TEXT.equals((Object)leftExpressionDataType) || TSDataType.TEXT.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.TEXT, TSDataType.STRING);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.TEXT, TSDataType.STRING);
                } else if (TSDataType.BLOB.equals((Object)leftExpressionDataType) || TSDataType.BLOB.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.BLOB);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.BLOB);
                } else if (TSDataType.TIMESTAMP.equals((Object)leftExpressionDataType) || TSDataType.TIMESTAMP.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.TIMESTAMP, TSDataType.INT64);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.TIMESTAMP, TSDataType.INT64);
                } else {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                }
            }
            return this.setExpressionType(compareBinaryExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitBetweenExpression(BetweenExpression betweenExpression, Function<String, TSDataType> context) {
            this.process(betweenExpression.getFirstExpression(), context);
            this.process(betweenExpression.getSecondExpression(), context);
            this.process(betweenExpression.getThirdExpression(), context);
            return this.setExpressionType(betweenExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitFunctionExpression(FunctionExpression functionExpression, Function<String, TSDataType> context) {
            List<Expression> inputExpressions = functionExpression.getExpressions();
            for (Expression expression : inputExpressions) {
                this.process(expression, context);
            }
            if (functionExpression.isBuiltInAggregationFunctionExpression()) {
                return this.setExpressionType(functionExpression, TypeInferenceUtils.getBuiltinAggregationDataType(functionExpression.getFunctionName(), ExpressionTypeAnalyzer.this.getInputExpressionTypeForAggregation(inputExpressions, functionExpression.getFunctionName())));
            }
            if (functionExpression.isBuiltInScalarFunctionExpression()) {
                return this.setExpressionType(functionExpression, TypeInferenceUtils.getBuiltInScalarFunctionDataType(functionExpression, (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(inputExpressions.get(0)))));
            }
            if (functionExpression.isExternalAggregationFunctionExpression()) {
                return this.setExpressionType(functionExpression, new UDAFInformationInferrer(functionExpression.getFunctionName()).inferOutputType(inputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList()), inputExpressions.stream().map(f -> (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(f))).collect(Collectors.toList()), functionExpression.getFunctionAttributes()));
            }
            return this.setExpressionType(functionExpression, new UDTFInformationInferrer(functionExpression.getFunctionName()).inferOutputType(inputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList()), inputExpressions.stream().map(f -> (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(f))).collect(Collectors.toList()), functionExpression.getFunctionAttributes()));
        }

        @Override
        public TSDataType visitTimeStampOperand(TimestampOperand timestampOperand, Function<String, TSDataType> context) {
            return this.setExpressionType(timestampOperand, TSDataType.INT64);
        }

        @Override
        public TSDataType visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Function<String, TSDataType> context) {
            TSDataType type;
            if (context != null && (type = context.apply(timeSeriesOperand.getOutputSymbol())) != null) {
                return this.setExpressionType(timeSeriesOperand, type);
            }
            return this.setExpressionType(timeSeriesOperand, timeSeriesOperand.getOperandType());
        }

        @Override
        public TSDataType visitConstantOperand(ConstantOperand constantOperand, Function<String, TSDataType> context) {
            return this.setExpressionType(constantOperand, constantOperand.getDataType());
        }

        @Override
        public TSDataType visitNullOperand(NullOperand nullOperand, Function<String, TSDataType> context) {
            return null;
        }

        @Override
        public TSDataType visitCaseWhenThenExpression(CaseWhenThenExpression caseWhenThenExpression, Function<String, TSDataType> context) {
            HashSet<TSDataType> typeSet = new HashSet<TSDataType>();
            for (WhenThenExpression whenThenExpression : caseWhenThenExpression.getWhenThenExpressions()) {
                typeSet.add(this.process((Expression)whenThenExpression, context));
            }
            if (!(caseWhenThenExpression.getElseExpression() instanceof NullOperand)) {
                typeSet.add(this.process(caseWhenThenExpression.getElseExpression(), context));
            }
            if (typeSet.contains(TSDataType.TEXT)) {
                if (typeSet.stream().anyMatch(tsDataType -> tsDataType != TSDataType.TEXT)) {
                    throw new SemanticException("CASE expression: TEXT and other types cannot exist at the same time");
                }
                return this.setExpressionType(caseWhenThenExpression, TSDataType.TEXT);
            }
            if (typeSet.contains(TSDataType.BOOLEAN)) {
                if (typeSet.stream().anyMatch(tsDataType -> tsDataType != TSDataType.BOOLEAN)) {
                    throw new SemanticException("CASE expression: BOOLEAN and other types cannot exist at the same time");
                }
                return this.setExpressionType(caseWhenThenExpression, TSDataType.BOOLEAN);
            }
            return this.setExpressionType(caseWhenThenExpression, TSDataType.DOUBLE);
        }

        @Override
        public TSDataType visitWhenThenExpression(WhenThenExpression whenThenExpression, Function<String, TSDataType> context) {
            TSDataType whenType = this.process(whenThenExpression.getWhen(), context);
            if (!whenType.equals((Object)TSDataType.BOOLEAN)) {
                throw new SemanticException(String.format("The expression in the WHEN clause must return BOOLEAN. expression: %s, actual data type: %s.", whenThenExpression.getWhen().getExpressionString(), whenType.name()));
            }
            TSDataType thenType = this.process(whenThenExpression.getThen(), context);
            return this.setExpressionType(whenThenExpression, thenType);
        }

        private TSDataType setExpressionType(Expression expression, TSDataType type) {
            ExpressionTypeAnalyzer.this.expressionTypes.put(NodeRef.of(expression), type);
            return type;
        }

        private void checkInputExpressionDataType(String expressionString, TSDataType actual, TSDataType ... expected) {
            for (TSDataType type : expected) {
                if (actual != null && !actual.equals((Object)type)) continue;
                return;
            }
            throw new SemanticException(String.format("Invalid input expression data type. expression: %s, actual data type: %s, expected data type(s): %s.", expressionString, actual.name(), Arrays.toString(expected)));
        }

        private boolean isExpressionDataTypeSatisfy(Expression input, TSDataType ... expected) {
            NodeRef<Expression> inputRef = NodeRef.of(input);
            TSDataType actual = (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(inputRef);
            if (actual == null) {
                if (ExpressionTypeAnalyzer.this.expressionTypes.containsKey(inputRef)) {
                    return true;
                }
                throw new IllegalStateException(String.format("The type of input expression %s is unknown", input));
            }
            for (TSDataType type : expected) {
                if (!actual.equals((Object)type)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TypeProviderWrapper
    implements Function<String, TSDataType> {
        private final Map<String, TSDataType> typeMap;

        public TypeProviderWrapper(Map<String, TSDataType> typeMap) {
            this.typeMap = typeMap;
        }

        @Override
        public TSDataType apply(String s) {
            return this.typeMap.get(s);
        }
    }
}

