/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowSchemaTemplateTask
implements IConfigTask {
    private final ShowSchemaTemplateStatement showSchemaTemplateStatement;

    public ShowSchemaTemplateTask(ShowSchemaTemplateStatement showSchemaTemplateStatement) {
        this.showSchemaTemplateStatement = showSchemaTemplateStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showSchemaTemplate(this.showSchemaTemplateStatement);
    }

    public static void buildTSBlock(List<Template> templateList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showSchemaTemplateHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        Optional<List<Template>> optional = Optional.ofNullable(templateList);
        ((List)optional.orElse(new ArrayList())).forEach(template -> {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(template.getName(), TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        });
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowSchemaTemplateHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

