/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe;

import java.util.Map;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeFunctionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeFunctionSupport.class);

    public static void applyNowFunctionToExtractorAttributes(Map<String, String> extractorAttributes, String sourceKey, String extractorKey, long currentTime) {
        Pair<String, String> pair = PipeFunctionSupport.getExtractorAttributesKeyAndValue(extractorAttributes, sourceKey, extractorKey);
        if (pair == null) {
            return;
        }
        if (PipeFunctionSupport.isNowFunction((String)pair.right)) {
            extractorAttributes.replace((String)pair.left, String.valueOf(currentTime));
        }
    }

    private static Pair<String, String> getExtractorAttributesKeyAndValue(Map<String, String> extractorAttributes, String sourceKey, String extractorKey) {
        String key = sourceKey;
        String value = extractorAttributes.get(key);
        if (value != null) {
            return new Pair((Object)key, (Object)value);
        }
        try {
            key = sourceKey.substring(7);
            value = extractorAttributes.get(key);
        }
        catch (Exception e) {
            LOGGER.warn("The prefix of sourceKey is not 'source.'. Please check the parameters passed in: {}", (Object)sourceKey, (Object)e);
        }
        if (value != null) {
            return new Pair((Object)key, (Object)value);
        }
        key = extractorKey;
        value = extractorAttributes.get(key);
        if (value != null) {
            return new Pair((Object)key, (Object)value);
        }
        return null;
    }

    private static boolean isNowFunction(String value) {
        return "now".equalsIgnoreCase(value.trim());
    }
}

