/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.CartesianProductVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.QueryContextProvider;

public class ConcatExpressionWithSuffixPathsVisitor
extends CartesianProductVisitor<Context> {
    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression functionExpression, Context context) {
        ArrayList extendedExpressions = new ArrayList();
        if ("count_if".equalsIgnoreCase(functionExpression.getFunctionName())) {
            extendedExpressions.add((List)this.process(functionExpression.getExpressions().get(0), context));
            List<Expression> children = functionExpression.getExpressions();
            for (int i = 1; i < children.size(); ++i) {
                extendedExpressions.add(Collections.singletonList(children.get(i)));
            }
        } else {
            functionExpression.getExpressions().forEach(expression -> extendedExpressions.add((List)this.process((Expression)expression, context)));
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressionsWithMemoryCheck(functionExpression, childExpressionsList, context.getQueryContext());
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Context context) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        ArrayList<PartialPath> actualPaths = new ArrayList<PartialPath>();
        if (rawPath.getFullPath().startsWith("root.")) {
            actualPaths.add(rawPath);
            context.getPatternTree().appendPathPattern(rawPath);
        } else {
            for (PartialPath prefixPath : context.getPrefixPaths()) {
                PartialPath concatPath = prefixPath.concatPath(rawPath);
                context.getPatternTree().appendPathPattern(concatPath);
                actualPaths.add(concatPath);
            }
        }
        return ExpressionUtils.reconstructTimeSeriesOperandsWithMemoryCheck(timeSeriesOperand, actualPaths, context.getQueryContext());
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return Collections.singletonList(constantOperand);
    }

    public static class Context
    implements QueryContextProvider {
        private final List<PartialPath> prefixPaths;
        private final PathPatternTree patternTree;
        private final MPPQueryContext queryContext;

        public Context(List<PartialPath> prefixPaths, PathPatternTree patternTree, MPPQueryContext queryContext) {
            this.prefixPaths = prefixPaths;
            this.patternTree = patternTree;
            Validate.notNull((Object)queryContext, (String)"QueryContext is null", (Object[])new Object[0]);
            this.queryContext = queryContext;
        }

        public List<PartialPath> getPrefixPaths() {
            return this.prefixPaths;
        }

        public PathPatternTree getPatternTree() {
            return this.patternTree;
        }

        @Override
        public MPPQueryContext getQueryContext() {
            return this.queryContext;
        }
    }
}

