/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum DeleteNodeType {
    TREE_DELETE_NODE(1),
    RELATIONAL_DELETE_NODE(2);

    public static final int BYTES = 2;
    private final short nodeType;

    private DeleteNodeType(short nodeType) {
        this.nodeType = nodeType;
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((short)this.nodeType, (ByteBuffer)buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.nodeType, (OutputStream)stream);
    }

    public static AbstractDeleteDataNode deserializeFromDAL(ByteBuffer buffer) {
        short nodeType = buffer.getShort();
        switch (nodeType) {
            case 1: {
                return DeleteDataNode.deserializeFromDAL(buffer);
            }
            case 2: {
                return RelationalDeleteDataNode.deserializeFromDAL(buffer);
            }
        }
        throw new IllegalArgumentException("Invalid node type: " + nodeType);
    }
}

