/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;

public class ResolvedFunctionCallBuilder {
    private final ResolvedFunction resolvedFunction;
    private List<Expression> argumentValues = new ArrayList<Expression>();

    public static ResolvedFunctionCallBuilder builder(ResolvedFunction resolvedFunction) {
        return new ResolvedFunctionCallBuilder(resolvedFunction);
    }

    private ResolvedFunctionCallBuilder(ResolvedFunction resolvedFunction) {
        this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
    }

    public ResolvedFunctionCallBuilder addArgument(Expression value) {
        Objects.requireNonNull(value, "value is null");
        this.argumentValues.add(value);
        return this;
    }

    public ResolvedFunctionCallBuilder setArguments(List<Expression> values) {
        Objects.requireNonNull(values, "values is null");
        this.argumentValues = new ArrayList<Expression>(values);
        return this;
    }

    public FunctionCall build() {
        return new FunctionCall(this.resolvedFunction.toQualifiedName(), this.argumentValues);
    }
}

