/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class Symbol
implements Comparable<Symbol> {
    private final String name;

    public static Symbol from(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference), (String)"Unexpected expression: %s", (Object)expression);
        return new Symbol(((SymbolReference)expression).getName());
    }

    public Symbol(String name) {
        Objects.requireNonNull(name, "name is null");
        this.name = name;
    }

    public static Symbol of(String name) {
        Objects.requireNonNull(name, "name is null");
        return new Symbol(name);
    }

    public String getName() {
        return this.name;
    }

    public SymbolReference toSymbolReference() {
        return new SymbolReference(this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name.equals(symbol.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Symbol o) {
        return this.name.compareTo(o.name);
    }

    public static void serialize(Symbol symbol, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)symbol.getName(), (ByteBuffer)byteBuffer);
    }

    public static void serialize(Symbol symbol, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)symbol.getName(), (OutputStream)stream);
    }

    public static Symbol deserialize(ByteBuffer byteBuffer) {
        return new Symbol(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
    }
}

