/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.DataOrganizationSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FrameBound;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowFrame;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class WindowNode
extends SingleChildProcessNode {
    private final Set<Symbol> prePartitionedInputs;
    private final DataOrganizationSpecification specification;
    private final int preSortedOrderPrefix;
    private final Map<Symbol, Function> windowFunctions;
    private final Optional<Symbol> hashSymbol;

    public WindowNode(PlanNodeId id, PlanNode child, DataOrganizationSpecification specification, Map<Symbol, Function> windowFunctions, Optional<Symbol> hashSymbol, Set<Symbol> prePartitionedInputs, int preSortedOrderPrefix) {
        super(id, child);
        prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        ImmutableSet partitionBy = ImmutableSet.copyOf(specification.getPartitionBy());
        Optional<OrderingScheme> orderingScheme = specification.getOrderingScheme();
        Preconditions.checkArgument((boolean)partitionBy.containsAll((Collection)prePartitionedInputs), (Object)"prePartitionedInputs must be contained in partitionBy");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || orderingScheme.isPresent() && preSortedOrderPrefix <= orderingScheme.get().getOrderBy().size() ? 1 : 0) != 0, (Object)"Cannot have sorted more symbols than those requested");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || partitionBy.equals((Object)prePartitionedInputs) ? 1 : 0) != 0, (Object)"preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned");
        this.prePartitionedInputs = prePartitionedInputs;
        this.specification = specification;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.hashSymbol = hashSymbol;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    public WindowNode(PlanNodeId id, DataOrganizationSpecification specification, Map<Symbol, Function> windowFunctions, Optional<Symbol> hashSymbol, Set<Symbol> prePartitionedInputs, int preSortedOrderPrefix) {
        super(id);
        this.prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        this.specification = specification;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.hashSymbol = hashSymbol;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    @Override
    public PlanNode clone() {
        return new WindowNode(this.id, this.child, this.specification, this.windowFunctions, this.hashSymbol, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.child.getOutputSymbols(), this.windowFunctions.keySet()));
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new WindowNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.windowFunctions, this.hashSymbol, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitWindowFunction(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_WINDOW_FUNCTION.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.prePartitionedInputs.size(), (ByteBuffer)byteBuffer);
        this.prePartitionedInputs.forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
        this.specification.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.preSortedOrderPrefix, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.windowFunctions.size(), (ByteBuffer)byteBuffer);
        this.windowFunctions.forEach((symbol, function) -> {
            Symbol.serialize(symbol, byteBuffer);
            function.serialize(byteBuffer);
        });
        if (this.hashSymbol.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Symbol.serialize(this.hashSymbol.get(), byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_WINDOW_FUNCTION.serialize(stream);
        ReadWriteIOUtils.write((int)this.prePartitionedInputs.size(), (OutputStream)stream);
        for (Symbol symbol : this.prePartitionedInputs) {
            Symbol.serialize(symbol, stream);
        }
        this.specification.serialize(stream);
        ReadWriteIOUtils.write((int)this.preSortedOrderPrefix, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.windowFunctions.size(), (OutputStream)stream);
        for (Map.Entry entry : this.windowFunctions.entrySet()) {
            Symbol symbol = (Symbol)entry.getKey();
            Function function = (Function)entry.getValue();
            Symbol.serialize(symbol, stream);
            function.serialize(stream);
        }
        if (this.hashSymbol.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Symbol.serialize(this.hashSymbol.get(), stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
    }

    public static WindowNode deserialize(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashSet<Symbol> prePartitionedInputs = new HashSet<Symbol>(size);
        for (int i = 0; i < size; ++i) {
            prePartitionedInputs.add(Symbol.deserialize(buffer));
        }
        DataOrganizationSpecification specification = DataOrganizationSpecification.deserialize(buffer);
        int preSortedOrderPrefix = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<Symbol, Function> windowFunctions = new HashMap<Symbol, Function>(size);
        for (int i = 0; i < size; ++i) {
            Symbol symbol = Symbol.deserialize(buffer);
            Function function = new Function(buffer);
            windowFunctions.put(symbol, function);
        }
        Optional<Symbol> hashSymbol = ReadWriteIOUtils.readByte((ByteBuffer)buffer) == 1 ? Optional.of(Symbol.deserialize(buffer)) : Optional.empty();
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new WindowNode(planNodeId, specification, windowFunctions, hashSymbol, prePartitionedInputs, preSortedOrderPrefix);
    }

    public Set<Symbol> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    public DataOrganizationSpecification getSpecification() {
        return this.specification;
    }

    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    public Map<Symbol, Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Immutable
    public static final class Function {
        private final ResolvedFunction resolvedFunction;
        private final List<Expression> arguments;
        private final Frame frame;
        private final boolean ignoreNulls;

        public Function(ResolvedFunction resolvedFunction, List<Expression> arguments, Frame frame, boolean ignoreNulls) {
            this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
            this.arguments = Objects.requireNonNull(arguments, "arguments is null");
            this.frame = Objects.requireNonNull(frame, "frame is null");
            this.ignoreNulls = ignoreNulls;
        }

        public ResolvedFunction getResolvedFunction() {
            return this.resolvedFunction;
        }

        public Frame getFrame() {
            return this.frame;
        }

        public List<Expression> getArguments() {
            return this.arguments;
        }

        public int hashCode() {
            return Objects.hash(this.resolvedFunction, this.arguments, this.frame, this.ignoreNulls);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return Objects.equals(this.resolvedFunction, other.resolvedFunction) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.frame, other.frame) && this.ignoreNulls == other.ignoreNulls;
        }

        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }

        public void serialize(ByteBuffer byteBuffer) {
            this.resolvedFunction.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.arguments.size(), (ByteBuffer)byteBuffer);
            this.arguments.forEach(argument -> Expression.serialize(argument, byteBuffer));
            this.frame.serialize(byteBuffer);
            ReadWriteIOUtils.write((Boolean)this.ignoreNulls, (ByteBuffer)byteBuffer);
        }

        public void serialize(DataOutputStream stream) throws IOException {
            this.resolvedFunction.serialize(stream);
            ReadWriteIOUtils.write((int)this.arguments.size(), (OutputStream)stream);
            for (Expression argument : this.arguments) {
                Expression.serialize(argument, stream);
            }
            this.frame.serialize(stream);
            ReadWriteIOUtils.write((Boolean)this.ignoreNulls, (OutputStream)stream);
        }

        public Function(ByteBuffer buffer) {
            this.resolvedFunction = ResolvedFunction.deserialize(buffer);
            int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            this.arguments = new ArrayList<Expression>(size);
            for (int i = 0; i < size; ++i) {
                this.arguments.add(Expression.deserialize(buffer));
            }
            this.frame = new Frame(buffer);
            this.ignoreNulls = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        }
    }

    @Immutable
    public static class Frame {
        public static final Frame DEFAULT_FRAME = new Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        private final WindowFrame.Type type;
        private final FrameBound.Type startType;
        private final Optional<Symbol> startValue;
        private final Optional<Symbol> sortKeyCoercedForFrameStartComparison;
        private final FrameBound.Type endType;
        private final Optional<Symbol> endValue;
        private final Optional<Symbol> sortKeyCoercedForFrameEndComparison;
        private final Optional<Expression> originalStartValue;
        private final Optional<Expression> originalEndValue;

        public Frame(WindowFrame.Type type, FrameBound.Type startType, Optional<Symbol> startValue, Optional<Symbol> sortKeyCoercedForFrameStartComparison, FrameBound.Type endType, Optional<Symbol> endValue, Optional<Symbol> sortKeyCoercedForFrameEndComparison, Optional<Expression> originalStartValue, Optional<Expression> originalEndValue) {
            this.startType = Objects.requireNonNull(startType, "startType is null");
            this.startValue = Objects.requireNonNull(startValue, "startValue is null");
            this.sortKeyCoercedForFrameStartComparison = Objects.requireNonNull(sortKeyCoercedForFrameStartComparison, "sortKeyCoercedForFrameStartComparison is null");
            this.endType = Objects.requireNonNull(endType, "endType is null");
            this.endValue = Objects.requireNonNull(endValue, "endValue is null");
            this.sortKeyCoercedForFrameEndComparison = Objects.requireNonNull(sortKeyCoercedForFrameEndComparison, "sortKeyCoercedForFrameEndComparison is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.originalStartValue = Objects.requireNonNull(originalStartValue, "originalStartValue is null");
            this.originalEndValue = Objects.requireNonNull(originalEndValue, "originalEndValue is null");
            if (startValue.isPresent()) {
                Preconditions.checkArgument((boolean)originalStartValue.isPresent(), (Object)"originalStartValue must be present if startValue is present");
                if (type == WindowFrame.Type.RANGE) {
                    Preconditions.checkArgument((boolean)sortKeyCoercedForFrameStartComparison.isPresent(), (Object)"for frame of type RANGE, sortKeyCoercedForFrameStartComparison must be present if startValue is present");
                }
            }
            if (endValue.isPresent()) {
                Preconditions.checkArgument((boolean)originalEndValue.isPresent(), (Object)"originalEndValue must be present if endValue is present");
                if (type == WindowFrame.Type.RANGE) {
                    Preconditions.checkArgument((boolean)sortKeyCoercedForFrameEndComparison.isPresent(), (Object)"for frame of type RANGE, sortKeyCoercedForFrameEndComparison must be present if endValue is present");
                }
            }
        }

        public WindowFrame.Type getType() {
            return this.type;
        }

        public FrameBound.Type getStartType() {
            return this.startType;
        }

        public Optional<Symbol> getStartValue() {
            return this.startValue;
        }

        public Optional<Symbol> getSortKeyCoercedForFrameStartComparison() {
            return this.sortKeyCoercedForFrameStartComparison;
        }

        public FrameBound.Type getEndType() {
            return this.endType;
        }

        public Optional<Symbol> getEndValue() {
            return this.endValue;
        }

        public Optional<Symbol> getSortKeyCoercedForFrameEndComparison() {
            return this.sortKeyCoercedForFrameEndComparison;
        }

        public Optional<Expression> getOriginalStartValue() {
            return this.originalStartValue;
        }

        public Optional<Expression> getOriginalEndValue() {
            return this.originalEndValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            return this.type == frame.type && this.startType == frame.startType && Objects.equals(this.startValue, frame.startValue) && Objects.equals(this.sortKeyCoercedForFrameStartComparison, frame.sortKeyCoercedForFrameStartComparison) && this.endType == frame.endType && Objects.equals(this.endValue, frame.endValue) && Objects.equals(this.sortKeyCoercedForFrameEndComparison, frame.sortKeyCoercedForFrameEndComparison);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.startType, this.startValue, this.sortKeyCoercedForFrameStartComparison, this.endType, this.endValue, this.sortKeyCoercedForFrameEndComparison});
        }

        public void serialize(ByteBuffer buffer) {
            ReadWriteIOUtils.write((byte)((byte)this.type.ordinal()), (ByteBuffer)buffer);
            ReadWriteIOUtils.write((byte)((byte)this.startType.ordinal()), (ByteBuffer)buffer);
            if (this.startValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
                Symbol.serialize(this.startValue.get(), buffer);
            } else {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            }
            if (this.sortKeyCoercedForFrameStartComparison.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
                Symbol.serialize(this.sortKeyCoercedForFrameStartComparison.get(), buffer);
            } else {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            }
            ReadWriteIOUtils.write((byte)((byte)this.endType.ordinal()), (ByteBuffer)buffer);
            if (this.endValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
                Symbol.serialize(this.endValue.get(), buffer);
            } else {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            }
            if (this.sortKeyCoercedForFrameEndComparison.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
                Symbol.serialize(this.sortKeyCoercedForFrameEndComparison.get(), buffer);
            } else {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            }
            if (this.originalStartValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
                Expression.serialize(this.originalStartValue.get(), buffer);
            } else {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            }
            if (this.originalEndValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
                Expression.serialize(this.originalEndValue.get(), buffer);
            } else {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
            }
        }

        public void serialize(DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((byte)((byte)this.type.ordinal()), (OutputStream)stream);
            ReadWriteIOUtils.write((byte)((byte)this.startType.ordinal()), (OutputStream)stream);
            if (this.startValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                Symbol.serialize(this.startValue.get(), stream);
            } else {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            }
            if (this.sortKeyCoercedForFrameStartComparison.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                Symbol.serialize(this.sortKeyCoercedForFrameStartComparison.get(), stream);
            } else {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            }
            ReadWriteIOUtils.write((byte)((byte)this.endType.ordinal()), (OutputStream)stream);
            if (this.endValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                Symbol.serialize(this.endValue.get(), stream);
            } else {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            }
            if (this.sortKeyCoercedForFrameEndComparison.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                Symbol.serialize(this.sortKeyCoercedForFrameEndComparison.get(), stream);
            } else {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            }
            if (this.originalStartValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                Expression.serialize(this.originalStartValue.get(), stream);
            } else {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            }
            if (this.originalEndValue.isPresent()) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                Expression.serialize(this.originalEndValue.get(), stream);
            } else {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            }
        }

        public Frame(ByteBuffer byteBuffer) {
            this.type = WindowFrame.Type.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
            this.startType = FrameBound.Type.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
            this.startValue = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
            this.sortKeyCoercedForFrameStartComparison = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
            this.endType = FrameBound.Type.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
            this.endValue = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
            this.sortKeyCoercedForFrameEndComparison = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
            this.originalStartValue = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Expression.deserialize(byteBuffer)) : Optional.empty();
            this.originalEndValue = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Expression.deserialize(byteBuffer)) : Optional.empty();
        }
    }
}

