/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.TableDeviceSourceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryCountNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.DeviceAttributeCacheUpdater;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class AbstractTableDeviceQueryNode
extends TableDeviceSourceNode {
    protected final List<List<SchemaFilter>> tagDeterminedPredicateList;
    protected final Expression tagFuzzyPredicate;

    protected AbstractTableDeviceQueryNode(PlanNodeId planNodeId, String database, String tableName, List<List<SchemaFilter>> tagDeterminedPredicateList, Expression tagFuzzyPredicate, List<ColumnHeader> columnHeaderList, TDataNodeLocation senderLocation) {
        super(planNodeId, database, tableName, columnHeaderList, senderLocation);
        this.tagDeterminedPredicateList = tagDeterminedPredicateList;
        this.tagFuzzyPredicate = tagFuzzyPredicate;
    }

    public List<List<SchemaFilter>> getTagDeterminedFilterList() {
        return this.tagDeterminedPredicateList;
    }

    public Expression getTagFuzzyPredicate() {
        return this.tagFuzzyPredicate;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        this.getType().serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.database, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.tableName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.tagDeterminedPredicateList.size(), (ByteBuffer)byteBuffer);
        for (List<SchemaFilter> filterList : this.tagDeterminedPredicateList) {
            ReadWriteIOUtils.write((int)filterList.size(), (ByteBuffer)byteBuffer);
            for (SchemaFilter filter : filterList) {
                SchemaFilter.serialize((SchemaFilter)filter, (ByteBuffer)byteBuffer);
            }
        }
        ReadWriteIOUtils.write((byte)(this.tagFuzzyPredicate == null ? (byte)0 : 1), (ByteBuffer)byteBuffer);
        if (this.tagFuzzyPredicate != null) {
            Expression.serialize(this.tagFuzzyPredicate, byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (ByteBuffer)byteBuffer);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(byteBuffer);
        }
        if (Objects.nonNull(this.senderLocation)) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.senderLocation, byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.getType().serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.tagDeterminedPredicateList.size(), (OutputStream)stream);
        for (List<SchemaFilter> filterList : this.tagDeterminedPredicateList) {
            ReadWriteIOUtils.write((int)filterList.size(), (OutputStream)stream);
            for (SchemaFilter filter : filterList) {
                SchemaFilter.serialize((SchemaFilter)filter, (DataOutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((byte)(this.tagFuzzyPredicate == null ? (byte)0 : 1), (OutputStream)stream);
        if (this.tagFuzzyPredicate != null) {
            Expression.serialize(this.tagFuzzyPredicate, stream);
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (OutputStream)stream);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(stream);
        }
        if (Objects.nonNull(this.senderLocation)) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.senderLocation, stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    protected static PlanNode deserialize(ByteBuffer buffer, boolean isScan) {
        String database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String tableName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<List<SchemaFilter>> tagDeterminedFilterList = new ArrayList<List<SchemaFilter>>(size);
        for (int i = 0; i < size; ++i) {
            int singleSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            tagDeterminedFilterList.add(new ArrayList(singleSize));
            for (int k = 0; k < singleSize; ++k) {
                ((List)tagDeterminedFilterList.get(i)).add(SchemaFilter.deserialize((ByteBuffer)buffer));
            }
        }
        Expression tagFuzzyFilter = null;
        if (buffer.get() == 1) {
            tagFuzzyFilter = Expression.deserialize(buffer);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<ColumnHeader> columnHeaderList = new ArrayList<ColumnHeader>(size);
        for (int i = 0; i < size; ++i) {
            columnHeaderList.add(ColumnHeader.deserialize((ByteBuffer)buffer));
        }
        TDataNodeLocation senderLocation = null;
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            senderLocation = DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(buffer);
        }
        long limit = isScan ? ReadWriteIOUtils.readLong((ByteBuffer)buffer) : 0L;
        boolean needAligned = isScan ? ReadWriteIOUtils.readBool((ByteBuffer)buffer) : false;
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return isScan ? new TableDeviceQueryScanNode(planNodeId, database, tableName, tagDeterminedFilterList, tagFuzzyFilter, columnHeaderList, senderLocation, limit, needAligned) : new TableDeviceQueryCountNode(planNodeId, database, tableName, tagDeterminedFilterList, tagFuzzyFilter, columnHeaderList);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTableDeviceQueryNode that = (AbstractTableDeviceQueryNode)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tagDeterminedPredicateList, that.tagDeterminedPredicateList) && Objects.equals(this.tagFuzzyPredicate, that.tagFuzzyPredicate) && Objects.equals(this.columnHeaderList, that.columnHeaderList) && Objects.equals(this.schemaRegionReplicaSet, that.schemaRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.database, this.tableName, this.tagDeterminedPredicateList, this.tagFuzzyPredicate, this.columnHeaderList, this.schemaRegionReplicaSet);
    }

    protected String toStringMessage() {
        return "{database='" + this.database + '\'' + ", tableName='" + this.tableName + '\'' + ", tagDeterminedFilterList=" + this.tagDeterminedPredicateList + ", tagFuzzyFilter=" + this.tagFuzzyPredicate + ", columnHeaderList=" + this.columnHeaderList + ", schemaRegionReplicaSet=" + this.schemaRegionReplicaSet + '}';
    }
}

