/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAnchor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrEmpty;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrExclusion;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantified;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;

public final class IrRowPatternFlattener {
    private IrRowPatternFlattener() {
    }

    public static IrRowPattern optimize(IrRowPattern node) {
        return (IrRowPattern)new Visitor().process(node, false);
    }

    private static class Visitor
    extends IrRowPatternVisitor<IrRowPattern, Boolean> {
        private Visitor() {
        }

        @Override
        protected IrRowPattern visitIrRowPattern(IrRowPattern node, Boolean inExclusion) {
            throw new UnsupportedOperationException("unsupported node type: " + node.getClass().getName());
        }

        @Override
        protected IrRowPattern visitIrLabel(IrLabel node, Boolean inExclusion) {
            return node;
        }

        @Override
        protected IrRowPattern visitIrAnchor(IrAnchor node, Boolean inExclusion) {
            return node;
        }

        @Override
        protected IrRowPattern visitIrEmpty(IrEmpty node, Boolean inExclusion) {
            return node;
        }

        @Override
        protected IrRowPattern visitIrExclusion(IrExclusion node, Boolean inExclusion) {
            IrRowPattern child = (IrRowPattern)this.process(node.getPattern(), true);
            if (inExclusion.booleanValue()) {
                return child;
            }
            return new IrExclusion(child);
        }

        @Override
        protected IrRowPattern visitIrAlternation(IrAlternation node, Boolean inExclusion) {
            List children = (List)node.getPatterns().stream().map(pattern -> (IrRowPattern)this.process((IrRowPattern)pattern, inExclusion)).collect(ImmutableList.toImmutableList());
            children = (List)children.stream().flatMap(child -> {
                if (child instanceof IrAlternation) {
                    return ((IrAlternation)child).getPatterns().stream();
                }
                return Stream.of(child);
            }).collect(ImmutableList.toImmutableList());
            Optional<IrRowPattern> firstEmptyChild = children.stream().filter(IrEmpty.class::isInstance).findFirst();
            if (!firstEmptyChild.isPresent()) {
                return new IrAlternation(children);
            }
            if ((children = (List)children.stream().filter(child -> !(child instanceof IrEmpty) || child == firstEmptyChild.get()).collect(ImmutableList.toImmutableList())).size() == 1) {
                return new IrEmpty();
            }
            return new IrAlternation(children);
        }

        @Override
        protected IrRowPattern visitIrConcatenation(IrConcatenation node, Boolean inExclusion) {
            List children = (List)node.getPatterns().stream().map(pattern -> (IrRowPattern)this.process((IrRowPattern)pattern, inExclusion)).collect(ImmutableList.toImmutableList());
            if ((children = (List)children.stream().flatMap(child -> {
                if (child instanceof IrConcatenation) {
                    return ((IrConcatenation)child).getPatterns().stream();
                }
                return Stream.of(child);
            }).filter(child -> !(child instanceof IrEmpty)).collect(ImmutableList.toImmutableList())).isEmpty()) {
                return new IrEmpty();
            }
            if (children.size() == 1) {
                return (IrRowPattern)children.get(0);
            }
            return new IrConcatenation(children);
        }

        @Override
        protected IrRowPattern visitIrPermutation(IrPermutation node, Boolean inExclusion) {
            List children = (List)node.getPatterns().stream().map(pattern -> (IrRowPattern)this.process((IrRowPattern)pattern, inExclusion)).filter(child -> !(child instanceof IrEmpty)).collect(ImmutableList.toImmutableList());
            if (children.isEmpty()) {
                return new IrEmpty();
            }
            if (children.size() == 1) {
                return (IrRowPattern)children.get(0);
            }
            return new IrPermutation(children);
        }

        @Override
        protected IrRowPattern visitIrQuantified(IrQuantified node, Boolean inExclusion) {
            IrRowPattern child = (IrRowPattern)this.process(node.getPattern(), inExclusion);
            if (child instanceof IrEmpty) {
                return child;
            }
            return new IrQuantified(child, node.getQuantifier());
        }
    }
}

