/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;

public class AnchorPattern
extends RowPattern {
    private final Type type;

    public AnchorPattern(NodeLocation location, Type type) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAnchorPattern(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnchorPattern o = (AnchorPattern)obj;
        return Objects.equals((Object)this.type, (Object)o.type);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return AnchorPattern.sameClass(this, other);
    }

    public static enum Type {
        PARTITION_START,
        PARTITION_END;

    }
}

