/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class CreateIndex
extends Statement {
    private final QualifiedName tableName;
    private final Identifier indexName;
    private final List<Identifier> columnList;

    public CreateIndex(QualifiedName tableName, Identifier indexName, List<Identifier> columnList) {
        super(null);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.indexName = Objects.requireNonNull(indexName, "indexName is null");
        Objects.requireNonNull(columnList, "columnList is null");
        Preconditions.checkArgument((!columnList.isEmpty() ? 1 : 0) != 0, (Object)"size of columnList should be larger than 1");
        this.columnList = columnList;
    }

    public CreateIndex(NodeLocation location, QualifiedName tableName, Identifier indexName, List<Identifier> columnList) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.indexName = Objects.requireNonNull(indexName, "indexName is null");
        Objects.requireNonNull(columnList, "columnList is null");
        Preconditions.checkArgument((!columnList.isEmpty() ? 1 : 0) != 0, (Object)"size of columnList should be larger than 1");
        this.columnList = columnList;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public Identifier getIndexName() {
        return this.indexName;
    }

    public List<Identifier> getColumnList() {
        return this.columnList;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateIndex(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateIndex that = (CreateIndex)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.columnList, that.columnList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.indexName, this.columnList);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("indexName", (Object)this.indexName).add("columnList", this.columnList).toString();
    }
}

