/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.tsfile.file.metadata.IDeviceID;

public class FetchDevice
extends Statement {
    private final String database;
    private final String tableName;
    private final List<Object[]> deviceIdList;
    private transient List<IDeviceID> partitionKeyList;

    public FetchDevice(String database, String tableName, List<Object[]> deviceIdList) {
        super(null);
        this.database = database;
        this.tableName = tableName;
        this.deviceIdList = DeviceIDFactory.truncateTailingNull(deviceIdList);
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Object[]> getDeviceIdList() {
        return this.deviceIdList;
    }

    public List<IDeviceID> getPartitionKeyList() {
        if (this.partitionKeyList == null) {
            this.partitionKeyList = DeviceIDFactory.convertRawDeviceIDs2PartitionKeys(this.tableName, this.deviceIdList);
        }
        return this.partitionKeyList;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFetchDevice(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchDevice that = (FetchDevice)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.deviceIdList, that.deviceIdList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.database, this.tableName, this.deviceIdList);
    }

    @Override
    public String toString() {
        return "FetchDevice{database='" + this.database + '\'' + ", tableName='" + this.tableName + '\'' + ", deviceIdList=" + this.deviceIdList + '}';
    }
}

