/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.load.config.LoadTsFileConfigurator;

public class LoadTsFile
extends Statement {
    private final String filePath;
    private int databaseLevel;
    private String database;
    private boolean deleteAfterLoad;
    private boolean convertOnTypeMismatch;
    private long tabletConversionThresholdBytes;
    private boolean autoCreateDatabase;
    private boolean verify;
    private boolean isAsyncLoad = false;
    private boolean isGeneratedByPipe = false;
    private final Map<String, String> loadAttributes;
    private List<File> tsFiles;
    private List<TsFileResource> resources;
    private List<Long> writePointCountList;
    private List<Boolean> isTableModel;

    public LoadTsFile(NodeLocation location, String filePath, Map<String, String> loadAttributes) {
        super(location);
        this.filePath = Objects.requireNonNull(filePath, "filePath is null");
        this.databaseLevel = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        this.deleteAfterLoad = false;
        this.convertOnTypeMismatch = true;
        this.tabletConversionThresholdBytes = IoTDBDescriptor.getInstance().getConfig().getLoadTabletConversionThresholdBytes();
        this.autoCreateDatabase = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        this.verify = true;
        this.loadAttributes = loadAttributes == null ? Collections.emptyMap() : loadAttributes;
        this.initAttributes();
        try {
            this.tsFiles = LoadTsFileStatement.processTsFile(new File(filePath));
            this.resources = new ArrayList<TsFileResource>();
            this.writePointCountList = new ArrayList<Long>();
            this.isTableModel = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), true));
        }
        catch (FileNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Map<String, String> getLoadAttributes() {
        return this.loadAttributes;
    }

    public void setAutoCreateDatabase(boolean autoCreateDatabase) {
        this.autoCreateDatabase = autoCreateDatabase;
    }

    public boolean isAutoCreateDatabase() {
        return this.autoCreateDatabase;
    }

    public boolean isDeleteAfterLoad() {
        return this.deleteAfterLoad;
    }

    public LoadTsFile setDeleteAfterLoad(boolean deleteAfterLoad) {
        this.deleteAfterLoad = deleteAfterLoad;
        return this;
    }

    public boolean isConvertOnTypeMismatch() {
        return this.convertOnTypeMismatch;
    }

    public LoadTsFile setConvertOnTypeMismatch(boolean convertOnTypeMismatch) {
        this.convertOnTypeMismatch = convertOnTypeMismatch;
        return this;
    }

    public long getTabletConversionThresholdBytes() {
        return this.tabletConversionThresholdBytes;
    }

    public boolean isVerifySchema() {
        return this.verify;
    }

    public int getDatabaseLevel() {
        return this.databaseLevel;
    }

    public String getDatabase() {
        return this.database;
    }

    public LoadTsFile setDatabase(String database) {
        this.database = database;
        return this;
    }

    public boolean isAsyncLoad() {
        return this.isAsyncLoad;
    }

    public void markIsGeneratedByPipe() {
        this.isGeneratedByPipe = true;
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public List<Boolean> getIsTableModel() {
        return this.isTableModel;
    }

    public void setIsTableModel(List<Boolean> isTableModel) {
        this.isTableModel = isTableModel;
    }

    public List<File> getTsFiles() {
        return this.tsFiles;
    }

    public void addTsFileResource(TsFileResource resource) {
        this.resources.add(resource);
    }

    public List<TsFileResource> getResources() {
        return this.resources;
    }

    public void addWritePointCount(long writePointCount) {
        this.writePointCountList.add(writePointCount);
    }

    public long getWritePointCount(int resourceIndex) {
        return this.writePointCountList.get(resourceIndex);
    }

    private void initAttributes() {
        this.databaseLevel = LoadTsFileConfigurator.parseOrGetDefaultDatabaseLevel(this.loadAttributes);
        this.database = LoadTsFileConfigurator.parseDatabaseName(this.loadAttributes);
        this.deleteAfterLoad = LoadTsFileConfigurator.parseOrGetDefaultOnSuccess(this.loadAttributes);
        this.convertOnTypeMismatch = LoadTsFileConfigurator.parseOrGetDefaultConvertOnTypeMismatch(this.loadAttributes);
        this.tabletConversionThresholdBytes = LoadTsFileConfigurator.parseOrGetDefaultTabletConversionThresholdBytes(this.loadAttributes);
        this.verify = LoadTsFileConfigurator.parseOrGetDefaultVerify(this.loadAttributes);
        this.isAsyncLoad = LoadTsFileConfigurator.parseOrGetDefaultAsyncLoad(this.loadAttributes);
    }

    public boolean reconstructStatementIfMiniFileConverted(List<Boolean> isMiniTsFile) {
        int lastNonMiniTsFileIndex = -1;
        int n = isMiniTsFile.size();
        for (int i = 0; i < n; ++i) {
            if (isMiniTsFile.get(i).booleanValue()) continue;
            ++lastNonMiniTsFileIndex;
            if (this.tsFiles != null) {
                this.tsFiles.set(lastNonMiniTsFileIndex, this.tsFiles.get(i));
            }
            if (this.isTableModel != null) {
                this.isTableModel.set(lastNonMiniTsFileIndex, this.isTableModel.get(i));
            }
            if (this.resources != null) {
                this.resources.set(lastNonMiniTsFileIndex, this.resources.get(i));
            }
            if (this.writePointCountList == null) continue;
            this.writePointCountList.set(lastNonMiniTsFileIndex, this.writePointCountList.get(i));
        }
        this.tsFiles = this.tsFiles != null ? this.tsFiles.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        this.isTableModel = this.isTableModel != null ? this.isTableModel.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        this.resources = this.resources != null ? this.resources.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        this.writePointCountList = this.writePointCountList != null ? this.writePointCountList.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        return this.tsFiles == null || this.tsFiles.isEmpty();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLoadTsFile(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.filePath, this.loadAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadTsFile other = (LoadTsFile)obj;
        return Objects.equals(this.filePath, other.filePath) && Objects.equals(this.loadAttributes, other.loadAttributes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filePath", (Object)this.filePath).add("loadAttributes", this.loadAttributes).toString();
    }
}

