/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ReconstructRegion
extends Statement {
    final int dataNodeId;
    final List<Integer> regionIds;

    public ReconstructRegion(int dataNodeId, List<Integer> regionIds) {
        super(null);
        this.dataNodeId = dataNodeId;
        this.regionIds = regionIds;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(ReconstructRegion.class, this.dataNodeId, this.regionIds);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReconstructRegion)) {
            return false;
        }
        ReconstructRegion another = (ReconstructRegion)obj;
        return this.dataNodeId == another.dataNodeId && this.regionIds.equals(another.regionIds);
    }

    @Override
    public String toString() {
        return String.format("reconstruct region %s of datanode %d", this.regionIds, this.dataNodeId);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitReconstructRegion(this, context);
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    public List<Integer> getRegionIds() {
        return this.regionIds;
    }
}

