/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class DatabaseSchemaStatement
extends Statement
implements IConfigStatement {
    private final DatabaseSchemaStatementType subType;
    private PartialPath databasePath;
    private Long ttl = null;
    private Long timePartitionInterval = null;
    private Integer schemaRegionGroupNum = null;
    private Integer dataRegionGroupNum = null;
    private boolean enablePrintExceptionLog = true;
    private Integer schemaReplicationFactor = null;
    private Integer dataReplicationFactor = null;

    public DatabaseSchemaStatement(DatabaseSchemaStatementType subType) {
        this.subType = subType;
        this.statementType = StatementType.STORAGE_GROUP_SCHEMA;
    }

    public DatabaseSchemaStatementType getSubType() {
        return this.subType;
    }

    public PartialPath getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(PartialPath databasePath) {
        this.databasePath = databasePath;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Integer getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(Integer schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public Integer getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(Integer dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public Long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(Long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public Integer getSchemaRegionGroupNum() {
        return this.schemaRegionGroupNum;
    }

    public void setSchemaRegionGroupNum(Integer schemaRegionGroupNum) {
        this.schemaRegionGroupNum = schemaRegionGroupNum;
    }

    public Integer getDataRegionGroupNum() {
        return this.dataRegionGroupNum;
    }

    public void setDataRegionGroupNum(Integer dataRegionGroupNum) {
        this.dataRegionGroupNum = dataRegionGroupNum;
    }

    public boolean getEnablePrintExceptionLog() {
        return this.enablePrintExceptionLog;
    }

    public void setEnablePrintExceptionLog(boolean enablePrintExceptionLog) {
        this.enablePrintExceptionLog = enablePrintExceptionLog;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        switch (this.subType) {
            case CREATE: {
                return visitor.visitSetDatabase(this, context);
            }
        }
        return visitor.visitAlterDatabase(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return this.databasePath != null ? Collections.singletonList(this.databasePath) : Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_DATABASE), PrivilegeType.MANAGE_DATABASE);
    }

    public String toString() {
        return "SetStorageGroupStatement{storageGroupPath=" + this.databasePath + ", ttl=" + this.ttl + ", schemaReplicationFactor=" + this.schemaReplicationFactor + ", dataReplicationFactor=" + this.dataReplicationFactor + ", timePartitionInterval=" + this.timePartitionInterval + ", schemaRegionGroupNum=" + this.schemaRegionGroupNum + ", dataRegionGroupNum=" + this.dataRegionGroupNum + '}';
    }

    public static enum DatabaseSchemaStatementType {
        CREATE,
        ALTER;

    }
}

