/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class CreateTrainingStatement
extends Statement
implements IConfigStatement {
    private final String modelId;
    private Map<String, String> parameters;
    private String existingModelId = null;
    private List<PartialPath> targetPathPatterns;
    private List<List<Long>> targetTimeRanges;

    public CreateTrainingStatement(String modelId) {
        this.modelId = modelId;
    }

    public void setTargetPathPatterns(List<PartialPath> targetPathPatterns) {
        this.targetPathPatterns = targetPathPatterns;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getExistingModelId() {
        return this.existingModelId;
    }

    public List<PartialPath> getTargetPathPatterns() {
        return this.targetPathPatterns;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setExistingModelId(String existingModelId) {
        this.existingModelId = existingModelId;
    }

    public void setTargetTimeRanges(List<List<Long>> targetTimeRanges) {
        this.targetTimeRanges = targetTimeRanges;
    }

    public List<List<Long>> getTargetTimeRanges() {
        return this.targetTimeRanges;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId, this.existingModelId, this.parameters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTrainingStatement)) {
            return false;
        }
        CreateTrainingStatement target = (CreateTrainingStatement)obj;
        return this.modelId.equals(target.modelId) && Objects.equals(this.existingModelId, target.existingModelId) && Objects.equals(this.parameters, target.parameters);
    }

    public String toString() {
        return "CreateTrainingStatement{modelId='" + this.modelId + '\'' + ", parameters=" + this.parameters + ", existingModelId='" + this.existingModelId + '\'' + ", targetPathPatterns=" + this.targetPathPatterns + ", targetTimeRanges=" + this.targetTimeRanges + '}';
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return this.targetPathPatterns;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTraining(this, context);
    }
}

