/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class CreatePipeStatement
extends Statement
implements IConfigStatement {
    private String pipeName;
    private boolean ifNotExistsCondition;
    private Map<String, String> extractorAttributes;
    private Map<String, String> processorAttributes;
    private Map<String, String> connectorAttributes;

    public CreatePipeStatement(StatementType createPipeStatement) {
        this.statementType = createPipeStatement;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean hasIfNotExistsCondition() {
        return this.ifNotExistsCondition;
    }

    public Map<String, String> getExtractorAttributes() {
        return this.extractorAttributes;
    }

    public Map<String, String> getProcessorAttributes() {
        return this.processorAttributes;
    }

    public Map<String, String> getConnectorAttributes() {
        return this.connectorAttributes;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public void setIfNotExists(boolean ifNotExistsCondition) {
        this.ifNotExistsCondition = ifNotExistsCondition;
    }

    public void setExtractorAttributes(Map<String, String> extractorAttributes) {
        this.extractorAttributes = extractorAttributes;
    }

    public void setProcessorAttributes(Map<String, String> processorAttributes) {
        this.processorAttributes = processorAttributes;
    }

    public void setConnectorAttributes(Map<String, String> connectorAttributes) {
        this.connectorAttributes = connectorAttributes;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.USE_PIPE), PrivilegeType.USE_PIPE);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreatePipe(this, context);
    }
}

