/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.pipe;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.tsfile.annotations.TableModel;

public class PipeEnrichedStatement
extends Statement {
    private Statement innerStatement;

    public PipeEnrichedStatement(Statement innerStatement) {
        this.statementType = StatementType.PIPE_ENRICHED;
        this.innerStatement = innerStatement;
    }

    public Statement getInnerStatement() {
        return this.innerStatement;
    }

    public void setInnerStatement(Statement innerStatement) {
        this.innerStatement = innerStatement;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitPipeEnrichedStatement(this, context);
    }

    @Override
    public boolean isDebug() {
        return this.innerStatement.isDebug();
    }

    @Override
    public void setDebug(boolean debug) {
        this.innerStatement.setDebug(debug);
    }

    @Override
    public boolean isQuery() {
        return !Objects.isNull(this.innerStatement) && this.innerStatement.isQuery();
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    @TableModel
    public org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement toRelationalStatement(MPPQueryContext context) {
        PipeEnriched pipeEnriched = new PipeEnriched(this.innerStatement.toRelationalStatement(context));
        if (pipeEnriched.getInnerStatement() instanceof InsertRows) {
            ((InsertRows)pipeEnriched.getInnerStatement()).setAllowCreateTable(true);
        }
        return pipeEnriched;
    }
}

