/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.BinaryGreatestColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.BinaryLeastColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.BooleanGreatestColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.BooleanLeastColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.DoubleGreatestColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.DoubleLeastColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.FloatGreatestColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.FloatLeastColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.Int32GreatestColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.Int32LeastColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.Int64GreatestColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.Int64LeastColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.MultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public abstract class AbstractGreatestLeastColumnTransformer
extends MultiColumnTransformer {
    protected AbstractGreatestLeastColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transform(builder, childrenColumns, i);
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transform(builder, childrenColumns, i);
                continue;
            }
            builder.appendNull();
        }
    }

    protected abstract void transform(ColumnBuilder var1, List<Column> var2, int var3);

    public static ColumnTransformer getGreatestColumnTransformer(Type type, List<ColumnTransformer> columnTransformers) {
        TypeEnum typeEnum = type.getTypeEnum();
        switch (typeEnum) {
            case BOOLEAN: {
                return new BooleanGreatestColumnTransformer(type, columnTransformers);
            }
            case INT32: 
            case DATE: {
                return new Int32GreatestColumnTransformer(type, columnTransformers);
            }
            case INT64: 
            case TIMESTAMP: {
                return new Int64GreatestColumnTransformer(type, columnTransformers);
            }
            case FLOAT: {
                return new FloatGreatestColumnTransformer(type, columnTransformers);
            }
            case DOUBLE: {
                return new DoubleGreatestColumnTransformer(type, columnTransformers);
            }
            case STRING: 
            case TEXT: {
                return new BinaryGreatestColumnTransformer(type, columnTransformers);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported data type: %s", typeEnum));
    }

    public static ColumnTransformer getLeastColumnTransformer(Type type, List<ColumnTransformer> columnTransformers) {
        TypeEnum typeEnum = type.getTypeEnum();
        switch (typeEnum) {
            case BOOLEAN: {
                return new BooleanLeastColumnTransformer(type, columnTransformers);
            }
            case INT32: 
            case DATE: {
                return new Int32LeastColumnTransformer(type, columnTransformers);
            }
            case INT64: 
            case TIMESTAMP: {
                return new Int64LeastColumnTransformer(type, columnTransformers);
            }
            case FLOAT: {
                return new FloatLeastColumnTransformer(type, columnTransformers);
            }
            case DOUBLE: {
                return new DoubleLeastColumnTransformer(type, columnTransformers);
            }
            case STRING: 
            case TEXT: {
                return new BinaryLeastColumnTransformer(type, columnTransformers);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported data type: %s", typeEnum));
    }

    @Override
    protected void checkType() {
    }
}

