/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.LogicalMultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class LogicalAndMultiColumnTransformer
extends LogicalMultiColumnTransformer {
    public LogicalAndMultiColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        boolean[] selectionCopy = (boolean[])selection.clone();
        boolean[] hasNull = new boolean[selection.length];
        ArrayList<Column> childrenColumns = new ArrayList<Column>();
        for (ColumnTransformer child : this.columnTransformerList) {
            child.evaluateWithSelection(selectionCopy);
            Column childColumn = child.getColumn();
            childrenColumns.add(childColumn);
            for (int i = 0; i < childColumn.getPositionCount(); ++i) {
                if (childColumn.isNull(i)) {
                    hasNull[i] = true;
                    continue;
                }
                if (childColumn.getBoolean(i)) continue;
                selectionCopy[i] = false;
            }
        }
        int positionCount = ((Column)childrenColumns.get(0)).getPositionCount();
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                if (!selectionCopy[i]) {
                    this.returnType.writeBoolean(builder, false);
                    continue;
                }
                if (hasNull[i]) {
                    builder.appendNull();
                    continue;
                }
                this.returnType.writeBoolean(builder, true);
                continue;
            }
            builder.appendNull();
        }
        this.initializeColumnCache(builder.build());
        for (ColumnTransformer child : this.columnTransformerList) {
            child.clearCache();
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            boolean result = true;
            boolean hasNull = false;
            for (Column column : childrenColumns) {
                if (column.isNull(i)) {
                    hasNull = true;
                    continue;
                }
                if (column.getBoolean(i)) continue;
                result = false;
                break;
            }
            if (!result) {
                this.returnType.writeBoolean(builder, false);
                continue;
            }
            if (hasNull) {
                builder.appendNull();
                continue;
            }
            this.returnType.writeBoolean(builder, true);
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        throw new UnsupportedOperationException("LogicalAndMultiColumnTransformer do not support doTransform with selection");
    }
}

