/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.intermediate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.adapter.ElasticSerializableRowRecordListBackedMultiColumnWindow;
import org.apache.iotdb.db.queryengine.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.db.queryengine.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.LayerCacheUtils;
import org.apache.iotdb.db.queryengine.transformation.datastructure.TVColumns;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.RowListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.ElasticSerializableRowList;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInputLayer
extends IntermediateLayer
implements IUDFInputDataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiInputLayer.class);
    private final LayerReader[] layerReaders;
    private final TSDataType[] dataTypes;
    private final TimeSelector timeHeap;
    private final TVColumns[] inputTVColumnsList;
    private final int[] currentConsumedIndexes;
    private final int[] nextConsumedIndexes;
    private final TsBlockBuilder tsBlockBuilder;
    private TsBlock cachedTsBlock = null;

    public MultiInputLayer(Expression expression, String queryId, float memoryBudgetInMB, List<LayerReader> parentLayerReaders) {
        super(expression, queryId, memoryBudgetInMB);
        this.layerReaders = parentLayerReaders.toArray(new LayerReader[0]);
        this.currentConsumedIndexes = new int[this.layerReaders.length];
        this.nextConsumedIndexes = new int[this.layerReaders.length];
        this.inputTVColumnsList = new TVColumns[this.layerReaders.length];
        this.dataTypes = new TSDataType[this.layerReaders.length];
        for (int i = 0; i < this.layerReaders.length; ++i) {
            this.dataTypes[i] = this.layerReaders[i].getDataTypes()[0];
        }
        this.tsBlockBuilder = new TsBlockBuilder(Arrays.asList(this.dataTypes));
        this.timeHeap = new TimeSelector(this.layerReaders.length << 1, true);
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return Arrays.asList(this.dataTypes);
    }

    @Override
    public YieldableState yield() throws Exception {
        this.tsBlockBuilder.reset();
        YieldableState state = this.updateInputColumns();
        if (state != YieldableState.YIELDABLE) {
            return state;
        }
        long endTime = Long.MAX_VALUE;
        for (TVColumns tvColumns : this.inputTVColumnsList) {
            if (tvColumns.isConstant()) continue;
            long tvColumnsEndTime = tvColumns.getEndTime();
            endTime = Math.min(tvColumnsEndTime, endTime);
        }
        long currentTime = -1L;
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        while (currentTime != endTime) {
            currentTime = this.timeHeap.pollFirst();
            timeBuilder.writeLong(currentTime);
            this.appendRowInBuilder(currentTime);
            this.tsBlockBuilder.declarePosition();
            this.updateTimeHeap();
        }
        this.cachedTsBlock = this.tsBlockBuilder.build();
        return YieldableState.YIELDABLE;
    }

    private YieldableState updateInputColumns() throws Exception {
        for (int i = 0; i < this.layerReaders.length; ++i) {
            if (this.canSkipInputTVColumns(i)) continue;
            YieldableState state = this.layerReaders[i].yield();
            if (state == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return state;
            }
            if (state != YieldableState.YIELDABLE) continue;
            Column[] columns = this.layerReaders[i].current();
            if (this.layerReaders[i].isConstantPointReader()) {
                this.inputTVColumnsList[i] = new TVColumns(columns[0]);
            } else {
                this.inputTVColumnsList[i] = new TVColumns((TimeColumn)columns[1], columns[0]);
                this.timeHeap.add(((TimeColumn)columns[1]).getStartTime());
            }
            this.currentConsumedIndexes[i] = 0;
            this.layerReaders[i].consumedAll();
        }
        return this.timeHeap.isEmpty() ? YieldableState.NOT_YIELDABLE_NO_MORE_DATA : YieldableState.YIELDABLE;
    }

    private boolean canSkipInputTVColumns(int index) {
        return this.inputTVColumnsList[index] != null && !this.hasConsumedAll(index);
    }

    private boolean hasConsumedAll(int index) {
        return this.inputTVColumnsList[index].getPositionCount() == this.currentConsumedIndexes[index];
    }

    private void appendRowInBuilder(long time) {
        for (int i = 0; i < this.inputTVColumnsList.length; ++i) {
            ColumnBuilder builder = this.tsBlockBuilder.getColumnBuilder(i);
            if (this.hasConsumedAll(i)) {
                builder.appendNull();
                continue;
            }
            TVColumns tvColumns = this.inputTVColumnsList[i];
            if (tvColumns.isConstant()) {
                builder.write(tvColumns.getValueColumn(), 0);
                continue;
            }
            int currentIndex = this.currentConsumedIndexes[i];
            long currentTime = tvColumns.getTimeByIndex(currentIndex);
            if (currentTime == time) {
                if (tvColumns.getValueColumn().isNull(currentIndex)) {
                    builder.appendNull();
                } else {
                    builder.write(tvColumns.getValueColumn(), currentIndex);
                }
                this.nextConsumedIndexes[i] = currentIndex + 1;
                continue;
            }
            builder.appendNull();
        }
    }

    private void updateTimeHeap() {
        for (int i = 0; i < this.inputTVColumnsList.length; ++i) {
            if (this.currentConsumedIndexes[i] == this.nextConsumedIndexes[i]) continue;
            this.currentConsumedIndexes[i] = this.nextConsumedIndexes[i];
            if (this.hasConsumedAll(i)) continue;
            this.timeHeap.add(this.inputTVColumnsList[i].getTimeByIndex(this.currentConsumedIndexes[i]));
        }
    }

    @Override
    public Column[] currentBlock() {
        Column[] ret = this.cachedTsBlock.getAllColumns();
        this.cachedTsBlock = null;
        return ret;
    }

    @Override
    public LayerReader constructReader() {
        return new LayerReader(){

            @Override
            public boolean isConstantPointReader() {
                return false;
            }

            @Override
            public void consumedAll() {
            }

            @Override
            public Column[] current() {
                return MultiInputLayer.this.currentBlock();
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputLayer.this.dataTypes;
            }

            @Override
            public YieldableState yield() throws Exception {
                return MultiInputLayer.this.yield();
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, final float memoryBudgetInMB) throws QueryProcessException {
        final MultiInputLayer udfInputDataSet = this;
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final ElasticSerializableRowList rowRecordList;
            private final ElasticSerializableRowRecordListBackedMultiColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.rowRecordList = new ElasticSerializableRowList(MultiInputLayer.this.dataTypes, MultiInputLayer.this.queryId, memoryBudgetInMB, 2);
                this.window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(this.rowRecordList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("LayerRowWindowReader index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                int pointsToBeCollected = endIndex - this.rowRecordList.size();
                if (pointsToBeCollected > 0) {
                    YieldableState yieldableState = LayerCacheUtils.yieldRows(udfInputDataSet, this.rowRecordList, pointsToBeCollected);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        this.beginIndex -= this.slidingStep;
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (this.rowRecordList.size() <= this.beginIndex) {
                        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                    }
                    endIndex = Math.min(endIndex, this.rowRecordList.size());
                }
                this.window.seek(this.beginIndex, endIndex, this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(endIndex - 1));
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.rowRecordList.setEvictionUpperBound(this.beginIndex + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(final SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final MultiInputLayer udfInputDataSet = this;
        final ElasticSerializableRowList rowRecordList = new ElasticSerializableRowList(this.dataTypes, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableRowRecordListBackedMultiColumnWindow window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(rowRecordList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private boolean hasCached = false;
            private long nextWindowTimeBegin = strategy.getDisplayWindowBegin();
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private long currentEndTime = Long.MAX_VALUE;
            private final RowListForwardIterator beginIterator = rowRecordList.constructIterator();
            private TimeColumn cachedBeginTimeColumn;
            private int cachedBeginConsumed;
            private TimeColumn cachedEndTimeColumn;
            private int cachedEndConsumed;

            @Override
            public YieldableState yield() throws Exception {
                Column[] columns;
                if (this.isFirstIteration) {
                    if (rowRecordList.size() == 0) {
                        YieldableState state = udfInputDataSet.yield();
                        if (state != YieldableState.YIELDABLE) {
                            return state;
                        }
                        Column[] columns2 = udfInputDataSet.currentBlock();
                        TimeColumn times = (TimeColumn)columns2[columns2.length - 1];
                        rowRecordList.put(columns2);
                        this.cachedEndTimeColumn = times;
                    }
                    if (this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = this.cachedEndTimeColumn.getStartTime();
                    }
                    boolean bl = this.hasAtLeastOneRow = rowRecordList.size() != 0;
                    if (this.hasAtLeastOneRow) {
                        this.currentEndTime = this.cachedEndTimeColumn.getEndTime();
                    }
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (this.currentEndTime < nextWindowTimeEnd) {
                    YieldableState state = udfInputDataSet.yield();
                    if (state == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) break;
                    columns = udfInputDataSet.currentBlock();
                    TimeColumn times = (TimeColumn)columns[columns.length - 1];
                    rowRecordList.put(columns);
                    this.currentEndTime = times.getEndTime();
                    this.nextIndexEnd += this.cachedEndTimeColumn.getPositionCount() - this.cachedEndConsumed;
                    this.cachedEndTimeColumn = times;
                    this.cachedEndConsumed = 0;
                }
                while (this.cachedEndConsumed < this.cachedEndTimeColumn.getPositionCount() && this.cachedEndTimeColumn.getLong(this.cachedEndConsumed) < nextWindowTimeEnd) {
                    ++this.cachedEndConsumed;
                    ++this.nextIndexEnd;
                }
                boolean findNextIndexBegin = false;
                while (!findNextIndexBegin) {
                    while (this.cachedBeginTimeColumn != null && this.cachedBeginConsumed < this.cachedBeginTimeColumn.getPositionCount()) {
                        if (this.cachedBeginTimeColumn.getLong(this.cachedBeginConsumed) >= this.nextWindowTimeBegin) {
                            findNextIndexBegin = true;
                            break;
                        }
                        ++this.cachedBeginConsumed;
                        ++this.nextIndexBegin;
                    }
                    if (findNextIndexBegin) continue;
                    if (this.beginIterator.hasNext()) {
                        this.beginIterator.next();
                        this.cachedBeginConsumed = 0;
                        columns = this.beginIterator.currentBlock();
                        this.cachedBeginTimeColumn = (TimeColumn)columns[columns.length - 1];
                        continue;
                    }
                    findNextIndexBegin = true;
                }
                if (this.nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < this.cachedEndTimeColumn.getEndTime()) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return YieldableState.YIELDABLE;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != this.nextIndexEnd || this.nextIndexEnd != rowRecordList.size();
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                rowRecordList.setEvictionUpperBound(this.nextIndexBegin + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final long sessionTimeGap = strategy.getSessionTimeGap();
        final MultiInputLayer udfInputDataSet = this;
        final ElasticSerializableRowList rowRecordList = new ElasticSerializableRowList(this.dataTypes, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableRowRecordListBackedMultiColumnWindow window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(rowRecordList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private TimeColumn cachedTimes;
            private int cachedConsumed;

            @Override
            public YieldableState yield() throws Exception {
                YieldableState state;
                if (this.isFirstIteration && (state = this.yieldInFirstIteration()) != YieldableState.YIELDABLE) {
                    return state;
                }
                if (!this.hasAtLeastOneRow || this.nextWindowTimeBegin >= displayWindowEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long curTime = this.cachedTimes.getLong(this.cachedConsumed);
                if (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    ++this.nextIndexEnd;
                    ++this.cachedConsumed;
                }
                boolean findWindow = false;
                while (!findWindow && this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    while (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                        long nextTime = this.cachedTimes.getLong(this.cachedConsumed);
                        if (nextTime >= displayWindowEnd) {
                            findWindow = true;
                            break;
                        }
                        if (nextTime - curTime > sessionTimeGap) {
                            findWindow = true;
                            break;
                        }
                        ++this.nextIndexEnd;
                        ++this.cachedConsumed;
                        curTime = nextTime;
                    }
                    if (findWindow || this.cachedTimes.getEndTime() >= displayWindowEnd) continue;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state2 != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                this.nextWindowTimeEnd = rowRecordList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldInFirstIteration() throws Exception {
                YieldableState state;
                if (rowRecordList.size() == 0 && (state = this.yieldAndCache()) != YieldableState.YIELDABLE) {
                    return state;
                }
                this.nextWindowTimeBegin = Math.max(displayWindowBegin, this.cachedTimes.getStartTime());
                this.hasAtLeastOneRow = rowRecordList.size() != 0;
                this.isFirstIteration = false;
                long currentEndTime = this.cachedTimes.getEndTime();
                while (currentEndTime < this.nextWindowTimeBegin) {
                    this.cachedConsumed = this.cachedTimes.getPositionCount();
                    this.nextIndexBegin += this.cachedConsumed;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.YIELDABLE) continue;
                    this.nextIndexEnd = this.nextIndexBegin;
                    return state2;
                }
                while (this.cachedConsumed < this.cachedTimes.getPositionCount() && this.cachedTimes.getLong(this.cachedConsumed) < this.nextWindowTimeBegin) {
                    ++this.cachedConsumed;
                    ++this.nextIndexBegin;
                }
                this.nextIndexEnd = this.nextIndexBegin;
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldAndCache() throws Exception {
                YieldableState state = udfInputDataSet.yield();
                if (state != YieldableState.YIELDABLE) {
                    return state;
                }
                Column[] columns = udfInputDataSet.currentBlock();
                TimeColumn times = (TimeColumn)columns[columns.length - 1];
                rowRecordList.put(columns);
                this.cachedTimes = times;
                this.cachedConsumed = 0;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < rowRecordList.size()) {
                    this.nextWindowTimeBegin = rowRecordList.getTime(this.nextIndexEnd);
                }
                rowRecordList.setEvictionUpperBound(this.nextIndexBegin + 1);
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy strategy, float memoryBudgetInMB) {
        throw new UnsupportedOperationException("StateWindowAccessStrategy only support one input series for now.");
    }
}

