/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi.UDFQueryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;

public class MappableUDFQueryRowTransformer
extends UDFQueryTransformer {
    protected final LayerReader layerReader;

    public MappableUDFQueryRowTransformer(LayerReader layerReader, UDTFExecutor executor) {
        super(executor);
        this.layerReader = layerReader;
    }

    @Override
    protected YieldableState yieldValue() throws Exception {
        YieldableState yieldableState = this.layerReader.yield();
        if (!YieldableState.YIELDABLE.equals((Object)yieldableState)) {
            return yieldableState;
        }
        Column[] columns = this.layerReader.current();
        this.cachedColumns = this.execute(columns);
        this.layerReader.consumedAll();
        return YieldableState.YIELDABLE;
    }

    private Column[] execute(Column[] columns) {
        int count = columns[0].getPositionCount();
        ColumnBuilder valueColumnBuilder = TypeUtils.initColumnBuilder(this.tsDataType, count);
        this.executor.execute(columns, valueColumnBuilder);
        int timeColumnIndex = columns.length - 1;
        Column timeColumn = columns[timeColumnIndex];
        Column valueColumn = valueColumnBuilder.build();
        return new Column[]{valueColumn, timeColumn};
    }

    @Override
    public boolean isConstantPointReader() {
        return false;
    }
}

