/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairTaskRecoverLogParser {
    private final File logFile;
    private static final Logger LOGGER = LoggerFactory.getLogger(RepairTaskRecoverLogParser.class);
    private final Map<RepairTimePartition, Set<String>> repairedTimePartitionsWithCannotRepairFiles = new HashMap<RepairTimePartition, Set<String>>();
    private long repairTaskStartTime = Long.MIN_VALUE;
    private RepairTimePartition currentTimePartition;
    private Set<String> currentTimePartitionCannotRepairFiles;

    public RepairTaskRecoverLogParser(File logFile) {
        this.logFile = logFile;
    }

    void parse() throws IOException {
        this.parseLogFile();
    }

    private void parseLogFile() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.logFile));){
            String curLine;
            while ((curLine = reader.readLine()) != null) {
                if (curLine.startsWith("TASK_START_TIME")) {
                    this.parseTaskStartTimeLog(curLine);
                    continue;
                }
                if (curLine.startsWith("START_TIME_PARTITION")) {
                    this.parseStartTimePartitionLog(curLine.trim());
                    continue;
                }
                if (curLine.startsWith("END_TIME_PARTITION")) {
                    this.parseEndTimePartitionLog(curLine.trim());
                    continue;
                }
                if (curLine.startsWith("TSFILE")) {
                    this.parseFileLog(curLine.trim());
                    continue;
                }
                throw new IllegalArgumentException("Unknown format of repair log");
            }
            if (this.currentTimePartitionCannotRepairFiles != null && !this.currentTimePartitionCannotRepairFiles.isEmpty()) {
                this.handleIncompleteRepairedTimePartition();
            }
        }
    }

    private void parseTaskStartTimeLog(String line) {
        if (this.repairTaskStartTime != Long.MIN_VALUE) {
            return;
        }
        String[] values = line.split(" ");
        if (values.length != 2) {
            throw new RuntimeException(String.format("String '%s' is not a legal repair log", line));
        }
        this.repairTaskStartTime = Long.parseLong(values[1]);
    }

    private void parseStartTimePartitionLog(String line) {
        String[] values;
        if (this.currentTimePartition != null) {
            this.handleIncompleteRepairedTimePartition();
        }
        if ((values = line.split(" ")).length != 4) {
            throw new RuntimeException(String.format("String '%s' is not a legal repair log", line));
        }
        this.currentTimePartition = new RepairTimePartition(values[1], values[2], Long.parseLong(values[3]));
        this.currentTimePartitionCannotRepairFiles = new HashSet<String>();
    }

    private void parseFileLog(String line) {
        if (line.length() <= "TSFILE".length()) {
            throw new RuntimeException(String.format("String '%s' is not a legal repair log", line));
        }
        String filePath = line.substring("TSFILE".length());
        File f = new File(filePath.trim());
        this.currentTimePartitionCannotRepairFiles.add(f.getName());
    }

    private void parseEndTimePartitionLog(String line) {
        this.repairedTimePartitionsWithCannotRepairFiles.put(this.currentTimePartition, this.currentTimePartitionCannotRepairFiles);
        this.currentTimePartition = null;
        this.currentTimePartitionCannotRepairFiles = null;
    }

    private void handleIncompleteRepairedTimePartition() {
        LOGGER.error("[{}][{}]Repair data log is not complete, time partition is {}.", new Object[]{this.currentTimePartition.getDatabaseName(), this.currentTimePartition.getDataRegionId(), this.currentTimePartition.getTimePartitionId()});
        this.repairedTimePartitionsWithCannotRepairFiles.put(this.currentTimePartition, this.currentTimePartitionCannotRepairFiles);
    }

    long getRepairDataTaskStartTime() {
        return this.repairTaskStartTime < 0L ? System.currentTimeMillis() : this.repairTaskStartTime;
    }

    Map<RepairTimePartition, Set<String>> getRepairedTimePartitionsWithCannotRepairFiles() {
        return this.repairedTimePartitionsWithCannotRepairFiles;
    }

    String getRepairLogFilePath() {
        return this.logFile.getAbsolutePath();
    }
}

