/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.Map;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.filter.basic.Filter;

public class TimeFilterForDeviceTTL {
    private final Filter timeFilter;
    private final Map<IDeviceID, Long> ttlCached;

    public TimeFilterForDeviceTTL(Filter timeFilter, Map<IDeviceID, Long> ttlCached) {
        this.timeFilter = timeFilter;
        this.ttlCached = ttlCached;
    }

    public boolean satisfyStartEndTime(long startTime, long endTime, IDeviceID deviceID) {
        long ttl = this.getTTL(deviceID);
        if (ttl != Long.MAX_VALUE) {
            long validStartTime = CommonDateTimeUtils.currentTime() - ttl;
            if (validStartTime > endTime) {
                return false;
            }
            return this.timeFilter.satisfyStartEndTime(validStartTime, endTime);
        }
        return this.timeFilter.satisfyStartEndTime(startTime, endTime);
    }

    public boolean satisfy(long time, IDeviceID deviceID) {
        long ttl = this.getTTL(deviceID);
        if (ttl != Long.MAX_VALUE) {
            long validStartTime = CommonDateTimeUtils.currentTime() - ttl;
            if (validStartTime > time) {
                return false;
            }
            return this.timeFilter.satisfy(validStartTime, null);
        }
        return this.timeFilter.satisfy(time, null);
    }

    private long getTTL(IDeviceID deviceID) {
        Long ttl = this.ttlCached.get(deviceID);
        if (ttl == null) {
            throw new IllegalArgumentException("deviceID should not be empty in getTTL method in TimeFilterForDeviceTTL");
        }
        return ttl;
    }

    public void removeTTLCache(IDeviceID deviceID) {
        this.ttlCached.remove(deviceID);
    }
}

