/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;

public class TimestampPrecisionUtils {
    public static String TIMESTAMP_PRECISION;
    private static final ConvertFunction<Long, TimeUnit, Long> convertToCurrPrecisionFunction;
    public static final TimeUnit currPrecision;

    public static long convertToCurrPrecision(long sourceTime, TimeUnit sourceUnit) {
        return convertToCurrPrecisionFunction.apply(sourceTime, sourceUnit);
    }

    public static void checkTimestampPrecision(long time) {
        boolean isTimestampPrecisionCheckEnabled = CommonDescriptor.getInstance().getConfig().isTimestampPrecisionCheckEnabled();
        if (!isTimestampPrecisionCheckEnabled) {
            return;
        }
        switch (TIMESTAMP_PRECISION) {
            case "ms": {
                if (time <= 10000000000000L && time >= -10000000000000L) break;
                throw new SemanticException(String.format("The timestamp is unexpectedly large, you may forget to set the timestamp precision.Current system timestamp precision is %s, please check whether the timestamp %s is correct.If you insist to insert this timestamp, please set timestamp_precision_check_enabled=false and restart the server.", TIMESTAMP_PRECISION, time));
            }
            case "us": {
                if (time <= 10000000000000000L && time >= -10000000000000L) break;
                throw new SemanticException(String.format("The timestamp is unexpectedly large, you may forget to set the timestamp precision.Current system timestamp precision is %s, please check whether the timestamp %s is correct.If you insist to insert this timestamp, please set timestamp_precision_check_enabled=false and restart the server.", TIMESTAMP_PRECISION, time));
            }
        }
    }

    static {
        switch (TIMESTAMP_PRECISION = CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ms": {
                convertToCurrPrecisionFunction = TimeUnit.MILLISECONDS::convert;
                currPrecision = TimeUnit.MILLISECONDS;
                break;
            }
            case "us": {
                convertToCurrPrecisionFunction = TimeUnit.MICROSECONDS::convert;
                currPrecision = TimeUnit.MICROSECONDS;
                break;
            }
            case "ns": {
                convertToCurrPrecisionFunction = TimeUnit.NANOSECONDS::convert;
                currPrecision = TimeUnit.NANOSECONDS;
                break;
            }
            default: {
                throw new UnsupportedOperationException("not supported time_precision: " + TIMESTAMP_PRECISION);
            }
        }
    }

    @FunctionalInterface
    private static interface ConvertFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2);
    }
}

