/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class MultiAlignedTVListIterator
implements MemPointIterator {
    protected List<TSDataType> tsDataTypeList;
    protected List<Integer> columnIndexList;
    protected List<AlignedTVList.AlignedTVListIterator> alignedTvListIterators;
    protected int floatPrecision;
    protected List<TSEncoding> encodingList;
    protected List<List<TimeRange>> valueColumnsDeletionList;
    protected boolean ignoreAllNullRows;
    protected boolean probeNext = false;
    protected boolean hasNext = false;
    protected List<TsBlock> tsBlocks;
    protected long currentTime;
    protected final int maxNumberOfPointsInPage;

    protected MultiAlignedTVListIterator(List<TSDataType> tsDataTypeList, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows, int maxNumberOfPointsInPage) {
        this.tsDataTypeList = tsDataTypeList;
        this.columnIndexList = columnIndexList;
        this.alignedTvListIterators = new ArrayList<AlignedTVList.AlignedTVListIterator>(alignedTvLists.size());
        for (AlignedTVList alignedTvList : alignedTvLists) {
            this.alignedTvListIterators.add(alignedTvList.iterator(tsDataTypeList, columnIndexList, timeColumnDeletion, null, floatPrecision, encodingList, ignoreAllNullRows, maxNumberOfPointsInPage));
        }
        this.valueColumnsDeletionList = valueColumnsDeletionList;
        this.floatPrecision = floatPrecision != null ? floatPrecision : 0;
        this.encodingList = encodingList;
        this.ignoreAllNullRows = ignoreAllNullRows;
        this.tsBlocks = new ArrayList<TsBlock>();
        this.maxNumberOfPointsInPage = maxNumberOfPointsInPage;
    }

    public boolean hasNextTimeValuePair() {
        if (!this.probeNext) {
            this.prepareNext();
        }
        return this.hasNext;
    }

    public TimeValuePair nextTimeValuePair() {
        if (!this.hasNextTimeValuePair()) {
            return null;
        }
        TsPrimitiveType[] vector = new TsPrimitiveType[this.tsDataTypeList.size()];
        for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
            AlignedTVList.AlignedTVListIterator iterator = this.alignedTvListIterators.get(this.currentIteratorIndex(columnIndex));
            vector[columnIndex] = iterator.getPrimitiveTypeObject(this.currentRowIndex(columnIndex), columnIndex);
        }
        TimeValuePair currentTvPair = new TimeValuePair(this.currentTime, TsPrimitiveType.getByType((TSDataType)TSDataType.VECTOR, (Object)vector));
        this.next();
        return currentTvPair;
    }

    public TimeValuePair currentTimeValuePair() {
        if (!this.hasNextTimeValuePair()) {
            return null;
        }
        TsPrimitiveType[] vector = new TsPrimitiveType[this.tsDataTypeList.size()];
        for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
            AlignedTVList.AlignedTVListIterator iterator = this.alignedTvListIterators.get(this.currentIteratorIndex(columnIndex));
            vector[columnIndex] = iterator.getPrimitiveTypeObject(this.currentRowIndex(columnIndex), columnIndex);
        }
        return new TimeValuePair(this.currentTime, TsPrimitiveType.getByType((TSDataType)TSDataType.VECTOR, (Object)vector));
    }

    @Override
    public boolean hasNextBatch() {
        return this.hasNextTimeValuePair();
    }

    @Override
    public TsBlock nextBatch() {
        TsBlockBuilder builder = new TsBlockBuilder(this.tsDataTypeList);
        TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
        while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
            timeBuilder.writeLong(this.currentTime);
            block9: for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
                int validColumnIndex;
                ColumnBuilder valueBuilder = builder.getColumnBuilder(columnIndex);
                AlignedTVList alignedTVList = this.alignedTvListIterators.get(this.currentIteratorIndex(columnIndex)).getAlignedTVList();
                int n = validColumnIndex = this.columnIndexList != null ? this.columnIndexList.get(columnIndex) : columnIndex;
                if (validColumnIndex < 0 || validColumnIndex >= alignedTVList.dataTypes.size()) {
                    valueBuilder.appendNull();
                    continue;
                }
                int valueIndex = alignedTVList.getValueIndex(this.currentRowIndex(columnIndex));
                if (alignedTVList.isNullValue(valueIndex, validColumnIndex)) {
                    valueBuilder.appendNull();
                    continue;
                }
                switch (this.tsDataTypeList.get(columnIndex)) {
                    case BOOLEAN: {
                        valueBuilder.writeBoolean(alignedTVList.getBooleanByValueIndex(valueIndex, validColumnIndex));
                        continue block9;
                    }
                    case INT32: 
                    case DATE: {
                        valueBuilder.writeInt(alignedTVList.getIntByValueIndex(valueIndex, validColumnIndex));
                        continue block9;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        valueBuilder.writeLong(alignedTVList.getLongByValueIndex(valueIndex, validColumnIndex));
                        continue block9;
                    }
                    case FLOAT: {
                        float valueF = alignedTVList.getFloatByValueIndex(valueIndex, validColumnIndex);
                        if (this.encodingList != null) {
                            valueF = alignedTVList.roundValueWithGivenPrecision(valueF, this.floatPrecision, this.encodingList.get(columnIndex));
                        }
                        valueBuilder.writeFloat(valueF);
                        continue block9;
                    }
                    case DOUBLE: {
                        double valueD = alignedTVList.getDoubleByValueIndex(valueIndex, validColumnIndex);
                        if (this.encodingList != null) {
                            valueD = alignedTVList.roundValueWithGivenPrecision(valueD, this.floatPrecision, this.encodingList.get(columnIndex));
                        }
                        valueBuilder.writeDouble(valueD);
                        continue block9;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        valueBuilder.writeBinary(alignedTVList.getBinaryByValueIndex(valueIndex, validColumnIndex));
                        continue block9;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataTypeList.get(columnIndex)));
                    }
                }
            }
            this.next();
            builder.declarePosition();
        }
        TsBlock tsBlock = builder.build();
        this.tsBlocks.add(tsBlock);
        return tsBlock;
    }

    @Override
    public TsBlock getBatch(int tsBlockIndex) {
        if (tsBlockIndex < 0 || tsBlockIndex >= this.tsBlocks.size()) {
            return null;
        }
        return this.tsBlocks.get(tsBlockIndex);
    }

    public long getUsedMemorySize() {
        return 0L;
    }

    protected abstract int currentIteratorIndex(int var1);

    protected abstract int currentRowIndex(int var1);

    public void close() throws IOException {
    }

    protected abstract void prepareNext();

    protected abstract void next();
}

