/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.apache.iotdb.commons.path.PathPatternNode;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PatternTreeMapFactory {
    private PatternTreeMapFactory() {
    }

    public static PatternTreeMap<String, StringSerializer> getTriggerPatternTreeMap() {
        return new PatternTreeMap(HashSet::new, (triggerName, set) -> set.add(triggerName), (triggerName, set) -> set.remove(triggerName), (PathPatternNode.Serializer)StringSerializer.getInstance());
    }

    public static PatternTreeMap<ModEntry, ModsSerializer> getModsPatternTreeMap() {
        return new PatternTreeMap(HashSet::new, (mod, set) -> set.add(mod), null, (PathPatternNode.Serializer)ModsSerializer.getInstance());
    }

    public static class StringSerializer
    implements PathPatternNode.Serializer<String> {
        public static StringSerializer getInstance() {
            return StringSerializerHolder.INSTANCE;
        }

        private StringSerializer() {
        }

        public void write(String s, ByteBuffer buffer) {
            ReadWriteIOUtils.write((String)s, (ByteBuffer)buffer);
        }

        public void write(String s, PublicBAOS stream) throws IOException {
            ReadWriteIOUtils.write((String)s, (OutputStream)stream);
        }

        public void write(String s, DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((String)s, (OutputStream)stream);
        }

        public String read(ByteBuffer buffer) {
            return ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }

        private static class StringSerializerHolder {
            private static final StringSerializer INSTANCE = new StringSerializer();

            private StringSerializerHolder() {
            }
        }
    }

    public static class ModsSerializer
    implements PathPatternNode.Serializer<ModEntry> {
        public void write(ModEntry modification, ByteBuffer buffer) {
            modification.serialize(buffer);
        }

        public void write(ModEntry modification, PublicBAOS stream) throws IOException {
            modification.serialize((OutputStream)stream);
        }

        public void write(ModEntry modification, DataOutputStream stream) throws IOException {
            modification.serialize(stream);
        }

        public ModEntry read(ByteBuffer buffer) {
            return ModEntry.createFrom(buffer);
        }

        public static ModsSerializer getInstance() {
            return ModsSerializerHolder.INSTANCE;
        }

        private static class ModsSerializerHolder {
            private static final ModsSerializer INSTANCE = new ModsSerializer();

            private ModsSerializerHolder() {
            }
        }
    }
}

