/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class Annotation
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=891");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=892");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=893");
    private final String message;
    private final String userName;
    private final DateTime annotationTime;

    public Annotation(String message, String userName, DateTime annotationTime) {
        this.message = message;
        this.userName = userName;
        this.annotationTime = annotationTime;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUserName() {
        return this.userName;
    }

    public DateTime getAnnotationTime() {
        return this.annotationTime;
    }

    protected Annotation(AnnotationBuilder<?, ?> b) {
        super(b);
        this.message = ((AnnotationBuilder)b).message;
        this.userName = ((AnnotationBuilder)b).userName;
        this.annotationTime = ((AnnotationBuilder)b).annotationTime;
    }

    public static AnnotationBuilder<?, ?> builder() {
        return new AnnotationBuilderImpl();
    }

    public AnnotationBuilder<?, ?> toBuilder() {
        return new AnnotationBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        DateTime this$annotationTime = this.getAnnotationTime();
        DateTime other$annotationTime = other.getAnnotationTime();
        return !(this$annotationTime == null ? other$annotationTime != null : !((Object)this$annotationTime).equals(other$annotationTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Annotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        DateTime $annotationTime = this.getAnnotationTime();
        result = result * 59 + ($annotationTime == null ? 43 : ((Object)$annotationTime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Annotation(message=" + this.getMessage() + ", userName=" + this.getUserName() + ", annotationTime=" + this.getAnnotationTime() + ")";
    }

    private static final class AnnotationBuilderImpl
    extends AnnotationBuilder<Annotation, AnnotationBuilderImpl> {
        private AnnotationBuilderImpl() {
        }

        @Override
        protected AnnotationBuilderImpl self() {
            return this;
        }

        @Override
        public Annotation build() {
            return new Annotation(this);
        }
    }

    public static abstract class AnnotationBuilder<C extends Annotation, B extends AnnotationBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String message;
        private String userName;
        private DateTime annotationTime;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AnnotationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Annotation instance, AnnotationBuilder<?, ?> b) {
            b.message(instance.message);
            b.userName(instance.userName);
            b.annotationTime(instance.annotationTime);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B message(String message) {
            this.message = message;
            return (B)this.self();
        }

        public B userName(String userName) {
            this.userName = userName;
            return (B)this.self();
        }

        public B annotationTime(DateTime annotationTime) {
            this.annotationTime = annotationTime;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Annotation.AnnotationBuilder(super=" + super.toString() + ", message=" + this.message + ", userName=" + this.userName + ", annotationTime=" + this.annotationTime + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<Annotation> {
        @Override
        public Class<Annotation> getType() {
            return Annotation.class;
        }

        @Override
        public Annotation decode(SerializationContext context, UaDecoder decoder) {
            String message = decoder.readString("Message");
            String userName = decoder.readString("UserName");
            DateTime annotationTime = decoder.readDateTime("AnnotationTime");
            return new Annotation(message, userName, annotationTime);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, Annotation value) {
            encoder.writeString("Message", value.getMessage());
            encoder.writeString("UserName", value.getUserName());
            encoder.writeDateTime("AnnotationTime", value.getAnnotationTime());
        }
    }
}

