/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ChannelSecurityToken
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=441");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=443");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=442");
    private final UInteger channelId;
    private final UInteger tokenId;
    private final DateTime createdAt;
    private final UInteger revisedLifetime;

    public ChannelSecurityToken(UInteger channelId, UInteger tokenId, DateTime createdAt, UInteger revisedLifetime) {
        this.channelId = channelId;
        this.tokenId = tokenId;
        this.createdAt = createdAt;
        this.revisedLifetime = revisedLifetime;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getChannelId() {
        return this.channelId;
    }

    public UInteger getTokenId() {
        return this.tokenId;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public UInteger getRevisedLifetime() {
        return this.revisedLifetime;
    }

    protected ChannelSecurityToken(ChannelSecurityTokenBuilder<?, ?> b) {
        super(b);
        this.channelId = ((ChannelSecurityTokenBuilder)b).channelId;
        this.tokenId = ((ChannelSecurityTokenBuilder)b).tokenId;
        this.createdAt = ((ChannelSecurityTokenBuilder)b).createdAt;
        this.revisedLifetime = ((ChannelSecurityTokenBuilder)b).revisedLifetime;
    }

    public static ChannelSecurityTokenBuilder<?, ?> builder() {
        return new ChannelSecurityTokenBuilderImpl();
    }

    public ChannelSecurityTokenBuilder<?, ?> toBuilder() {
        return new ChannelSecurityTokenBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelSecurityToken)) {
            return false;
        }
        ChannelSecurityToken other = (ChannelSecurityToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$channelId = this.getChannelId();
        UInteger other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !((Object)this$channelId).equals(other$channelId)) {
            return false;
        }
        UInteger this$tokenId = this.getTokenId();
        UInteger other$tokenId = other.getTokenId();
        if (this$tokenId == null ? other$tokenId != null : !((Object)this$tokenId).equals(other$tokenId)) {
            return false;
        }
        DateTime this$createdAt = this.getCreatedAt();
        DateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        UInteger this$revisedLifetime = this.getRevisedLifetime();
        UInteger other$revisedLifetime = other.getRevisedLifetime();
        return !(this$revisedLifetime == null ? other$revisedLifetime != null : !((Object)this$revisedLifetime).equals(other$revisedLifetime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelSecurityToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : ((Object)$channelId).hashCode());
        UInteger $tokenId = this.getTokenId();
        result = result * 59 + ($tokenId == null ? 43 : ((Object)$tokenId).hashCode());
        DateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        UInteger $revisedLifetime = this.getRevisedLifetime();
        result = result * 59 + ($revisedLifetime == null ? 43 : ((Object)$revisedLifetime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ChannelSecurityToken(channelId=" + this.getChannelId() + ", tokenId=" + this.getTokenId() + ", createdAt=" + this.getCreatedAt() + ", revisedLifetime=" + this.getRevisedLifetime() + ")";
    }

    private static final class ChannelSecurityTokenBuilderImpl
    extends ChannelSecurityTokenBuilder<ChannelSecurityToken, ChannelSecurityTokenBuilderImpl> {
        private ChannelSecurityTokenBuilderImpl() {
        }

        @Override
        protected ChannelSecurityTokenBuilderImpl self() {
            return this;
        }

        @Override
        public ChannelSecurityToken build() {
            return new ChannelSecurityToken(this);
        }
    }

    public static abstract class ChannelSecurityTokenBuilder<C extends ChannelSecurityToken, B extends ChannelSecurityTokenBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger channelId;
        private UInteger tokenId;
        private DateTime createdAt;
        private UInteger revisedLifetime;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ChannelSecurityTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ChannelSecurityToken instance, ChannelSecurityTokenBuilder<?, ?> b) {
            b.channelId(instance.channelId);
            b.tokenId(instance.tokenId);
            b.createdAt(instance.createdAt);
            b.revisedLifetime(instance.revisedLifetime);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B channelId(UInteger channelId) {
            this.channelId = channelId;
            return (B)this.self();
        }

        public B tokenId(UInteger tokenId) {
            this.tokenId = tokenId;
            return (B)this.self();
        }

        public B createdAt(DateTime createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B revisedLifetime(UInteger revisedLifetime) {
            this.revisedLifetime = revisedLifetime;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ChannelSecurityToken.ChannelSecurityTokenBuilder(super=" + super.toString() + ", channelId=" + this.channelId + ", tokenId=" + this.tokenId + ", createdAt=" + this.createdAt + ", revisedLifetime=" + this.revisedLifetime + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ChannelSecurityToken> {
        @Override
        public Class<ChannelSecurityToken> getType() {
            return ChannelSecurityToken.class;
        }

        @Override
        public ChannelSecurityToken decode(SerializationContext context, UaDecoder decoder) {
            UInteger channelId = decoder.readUInt32("ChannelId");
            UInteger tokenId = decoder.readUInt32("TokenId");
            DateTime createdAt = decoder.readDateTime("CreatedAt");
            UInteger revisedLifetime = decoder.readUInt32("RevisedLifetime");
            return new ChannelSecurityToken(channelId, tokenId, createdAt, revisedLifetime);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ChannelSecurityToken value) {
            encoder.writeUInt32("ChannelId", value.getChannelId());
            encoder.writeUInt32("TokenId", value.getTokenId());
            encoder.writeDateTime("CreatedAt", value.getCreatedAt());
            encoder.writeUInt32("RevisedLifetime", value.getRevisedLifetime());
        }
    }
}

