/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class DeleteEventDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=692");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=694");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=693");
    private final ByteString[] eventIds;

    public DeleteEventDetails(NodeId nodeId, ByteString[] eventIds) {
        super(nodeId);
        this.eventIds = eventIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ByteString[] getEventIds() {
        return this.eventIds;
    }

    protected DeleteEventDetails(DeleteEventDetailsBuilder<?, ?> b) {
        super((HistoryUpdateDetails.HistoryUpdateDetailsBuilder<?, ?>)b);
        this.eventIds = ((DeleteEventDetailsBuilder)b).eventIds;
    }

    public static DeleteEventDetailsBuilder<?, ?> builder() {
        return new DeleteEventDetailsBuilderImpl();
    }

    public DeleteEventDetailsBuilder<?, ?> toBuilder() {
        return new DeleteEventDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteEventDetails)) {
            return false;
        }
        DeleteEventDetails other = (DeleteEventDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getEventIds(), other.getEventIds());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeleteEventDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getEventIds());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteEventDetails(eventIds=" + Arrays.deepToString(this.getEventIds()) + ")";
    }

    private static final class DeleteEventDetailsBuilderImpl
    extends DeleteEventDetailsBuilder<DeleteEventDetails, DeleteEventDetailsBuilderImpl> {
        private DeleteEventDetailsBuilderImpl() {
        }

        @Override
        protected DeleteEventDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteEventDetails build() {
            return new DeleteEventDetails(this);
        }
    }

    public static abstract class DeleteEventDetailsBuilder<C extends DeleteEventDetails, B extends DeleteEventDetailsBuilder<C, B>>
    extends HistoryUpdateDetails.HistoryUpdateDetailsBuilder<C, B> {
        private ByteString[] eventIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteEventDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteEventDetails instance, DeleteEventDetailsBuilder<?, ?> b) {
            b.eventIds(instance.eventIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B eventIds(ByteString[] eventIds) {
            this.eventIds = eventIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteEventDetails.DeleteEventDetailsBuilder(super=" + super.toString() + ", eventIds=" + Arrays.deepToString(this.eventIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteEventDetails> {
        @Override
        public Class<DeleteEventDetails> getType() {
            return DeleteEventDetails.class;
        }

        @Override
        public DeleteEventDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            ByteString[] eventIds = decoder.readByteStringArray("EventIds");
            return new DeleteEventDetails(nodeId, eventIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteEventDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeByteStringArray("EventIds", value.getEventIds());
        }
    }
}

