/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class MethodAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=358");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=360");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=359");
    private final Boolean executable;
    private final Boolean userExecutable;

    public MethodAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean executable, Boolean userExecutable) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getExecutable() {
        return this.executable;
    }

    public Boolean getUserExecutable() {
        return this.userExecutable;
    }

    protected MethodAttributes(MethodAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.executable = ((MethodAttributesBuilder)b).executable;
        this.userExecutable = ((MethodAttributesBuilder)b).userExecutable;
    }

    public static MethodAttributesBuilder<?, ?> builder() {
        return new MethodAttributesBuilderImpl();
    }

    public MethodAttributesBuilder<?, ?> toBuilder() {
        return new MethodAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodAttributes)) {
            return false;
        }
        MethodAttributes other = (MethodAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$executable = this.getExecutable();
        Boolean other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        Boolean this$userExecutable = this.getUserExecutable();
        Boolean other$userExecutable = other.getUserExecutable();
        return !(this$userExecutable == null ? other$userExecutable != null : !((Object)this$userExecutable).equals(other$userExecutable));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MethodAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        Boolean $userExecutable = this.getUserExecutable();
        result = result * 59 + ($userExecutable == null ? 43 : ((Object)$userExecutable).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MethodAttributes(executable=" + this.getExecutable() + ", userExecutable=" + this.getUserExecutable() + ")";
    }

    private static final class MethodAttributesBuilderImpl
    extends MethodAttributesBuilder<MethodAttributes, MethodAttributesBuilderImpl> {
        private MethodAttributesBuilderImpl() {
        }

        @Override
        protected MethodAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public MethodAttributes build() {
            return new MethodAttributes(this);
        }
    }

    public static abstract class MethodAttributesBuilder<C extends MethodAttributes, B extends MethodAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private Boolean executable;
        private Boolean userExecutable;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MethodAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MethodAttributes instance, MethodAttributesBuilder<?, ?> b) {
            b.executable(instance.executable);
            b.userExecutable(instance.userExecutable);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B executable(Boolean executable) {
            this.executable = executable;
            return (B)this.self();
        }

        public B userExecutable(Boolean userExecutable) {
            this.userExecutable = userExecutable;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MethodAttributes.MethodAttributesBuilder(super=" + super.toString() + ", executable=" + this.executable + ", userExecutable=" + this.userExecutable + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MethodAttributes> {
        @Override
        public Class<MethodAttributes> getType() {
            return MethodAttributes.class;
        }

        @Override
        public MethodAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            Boolean executable = decoder.readBoolean("Executable");
            Boolean userExecutable = decoder.readBoolean("UserExecutable");
            return new MethodAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, executable, userExecutable);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MethodAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeBoolean("Executable", value.getExecutable());
            encoder.writeBoolean("UserExecutable", value.getUserExecutable());
        }
    }
}

