/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ModelChangeStructureDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=877");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=878");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=879");
    private final NodeId affected;
    private final NodeId affectedType;
    private final UByte verb;

    public ModelChangeStructureDataType(NodeId affected, NodeId affectedType, UByte verb) {
        this.affected = affected;
        this.affectedType = affectedType;
        this.verb = verb;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getAffected() {
        return this.affected;
    }

    public NodeId getAffectedType() {
        return this.affectedType;
    }

    public UByte getVerb() {
        return this.verb;
    }

    protected ModelChangeStructureDataType(ModelChangeStructureDataTypeBuilder<?, ?> b) {
        super(b);
        this.affected = ((ModelChangeStructureDataTypeBuilder)b).affected;
        this.affectedType = ((ModelChangeStructureDataTypeBuilder)b).affectedType;
        this.verb = ((ModelChangeStructureDataTypeBuilder)b).verb;
    }

    public static ModelChangeStructureDataTypeBuilder<?, ?> builder() {
        return new ModelChangeStructureDataTypeBuilderImpl();
    }

    public ModelChangeStructureDataTypeBuilder<?, ?> toBuilder() {
        return new ModelChangeStructureDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelChangeStructureDataType)) {
            return false;
        }
        ModelChangeStructureDataType other = (ModelChangeStructureDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$affected = this.getAffected();
        NodeId other$affected = other.getAffected();
        if (this$affected == null ? other$affected != null : !((Object)this$affected).equals(other$affected)) {
            return false;
        }
        NodeId this$affectedType = this.getAffectedType();
        NodeId other$affectedType = other.getAffectedType();
        if (this$affectedType == null ? other$affectedType != null : !((Object)this$affectedType).equals(other$affectedType)) {
            return false;
        }
        UByte this$verb = this.getVerb();
        UByte other$verb = other.getVerb();
        return !(this$verb == null ? other$verb != null : !((Object)this$verb).equals(other$verb));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelChangeStructureDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $affected = this.getAffected();
        result = result * 59 + ($affected == null ? 43 : ((Object)$affected).hashCode());
        NodeId $affectedType = this.getAffectedType();
        result = result * 59 + ($affectedType == null ? 43 : ((Object)$affectedType).hashCode());
        UByte $verb = this.getVerb();
        result = result * 59 + ($verb == null ? 43 : ((Object)$verb).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ModelChangeStructureDataType(affected=" + this.getAffected() + ", affectedType=" + this.getAffectedType() + ", verb=" + this.getVerb() + ")";
    }

    private static final class ModelChangeStructureDataTypeBuilderImpl
    extends ModelChangeStructureDataTypeBuilder<ModelChangeStructureDataType, ModelChangeStructureDataTypeBuilderImpl> {
        private ModelChangeStructureDataTypeBuilderImpl() {
        }

        @Override
        protected ModelChangeStructureDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public ModelChangeStructureDataType build() {
            return new ModelChangeStructureDataType(this);
        }
    }

    public static abstract class ModelChangeStructureDataTypeBuilder<C extends ModelChangeStructureDataType, B extends ModelChangeStructureDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId affected;
        private NodeId affectedType;
        private UByte verb;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModelChangeStructureDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ModelChangeStructureDataType instance, ModelChangeStructureDataTypeBuilder<?, ?> b) {
            b.affected(instance.affected);
            b.affectedType(instance.affectedType);
            b.verb(instance.verb);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B affected(NodeId affected) {
            this.affected = affected;
            return (B)this.self();
        }

        public B affectedType(NodeId affectedType) {
            this.affectedType = affectedType;
            return (B)this.self();
        }

        public B verb(UByte verb) {
            this.verb = verb;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ModelChangeStructureDataType.ModelChangeStructureDataTypeBuilder(super=" + super.toString() + ", affected=" + this.affected + ", affectedType=" + this.affectedType + ", verb=" + this.verb + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ModelChangeStructureDataType> {
        @Override
        public Class<ModelChangeStructureDataType> getType() {
            return ModelChangeStructureDataType.class;
        }

        @Override
        public ModelChangeStructureDataType decode(SerializationContext context, UaDecoder decoder) {
            NodeId affected = decoder.readNodeId("Affected");
            NodeId affectedType = decoder.readNodeId("AffectedType");
            UByte verb = decoder.readByte("Verb");
            return new ModelChangeStructureDataType(affected, affectedType, verb);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ModelChangeStructureDataType value) {
            encoder.writeNodeId("Affected", value.getAffected());
            encoder.writeNodeId("AffectedType", value.getAffectedType());
            encoder.writeByte("Verb", value.getVerb());
        }
    }
}

