/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ReferenceDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=518");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=520");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=519");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15182");
    private final NodeId referenceTypeId;
    private final Boolean isForward;
    private final ExpandedNodeId nodeId;
    private final QualifiedName browseName;
    private final LocalizedText displayName;
    private final NodeClass nodeClass;
    private final ExpandedNodeId typeDefinition;

    public ReferenceDescription(NodeId referenceTypeId, Boolean isForward, ExpandedNodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeClass nodeClass, ExpandedNodeId typeDefinition) {
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.nodeId = nodeId;
        this.browseName = browseName;
        this.displayName = displayName;
        this.nodeClass = nodeClass;
        this.typeDefinition = typeDefinition;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsForward() {
        return this.isForward;
    }

    public ExpandedNodeId getNodeId() {
        return this.nodeId;
    }

    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public ExpandedNodeId getTypeDefinition() {
        return this.typeDefinition;
    }

    protected ReferenceDescription(ReferenceDescriptionBuilder<?, ?> b) {
        super(b);
        this.referenceTypeId = ((ReferenceDescriptionBuilder)b).referenceTypeId;
        this.isForward = ((ReferenceDescriptionBuilder)b).isForward;
        this.nodeId = ((ReferenceDescriptionBuilder)b).nodeId;
        this.browseName = ((ReferenceDescriptionBuilder)b).browseName;
        this.displayName = ((ReferenceDescriptionBuilder)b).displayName;
        this.nodeClass = ((ReferenceDescriptionBuilder)b).nodeClass;
        this.typeDefinition = ((ReferenceDescriptionBuilder)b).typeDefinition;
    }

    public static ReferenceDescriptionBuilder<?, ?> builder() {
        return new ReferenceDescriptionBuilderImpl();
    }

    public ReferenceDescriptionBuilder<?, ?> toBuilder() {
        return new ReferenceDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceDescription)) {
            return false;
        }
        ReferenceDescription other = (ReferenceDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isForward = this.getIsForward();
        Boolean other$isForward = other.getIsForward();
        if (this$isForward == null ? other$isForward != null : !((Object)this$isForward).equals(other$isForward)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        ExpandedNodeId this$nodeId = this.getNodeId();
        ExpandedNodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        QualifiedName this$browseName = this.getBrowseName();
        QualifiedName other$browseName = other.getBrowseName();
        if (this$browseName == null ? other$browseName != null : !((Object)this$browseName).equals(other$browseName)) {
            return false;
        }
        LocalizedText this$displayName = this.getDisplayName();
        LocalizedText other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        NodeClass this$nodeClass = this.getNodeClass();
        NodeClass other$nodeClass = other.getNodeClass();
        if (this$nodeClass == null ? other$nodeClass != null : !this$nodeClass.equals(other$nodeClass)) {
            return false;
        }
        ExpandedNodeId this$typeDefinition = this.getTypeDefinition();
        ExpandedNodeId other$typeDefinition = other.getTypeDefinition();
        return !(this$typeDefinition == null ? other$typeDefinition != null : !((Object)this$typeDefinition).equals(other$typeDefinition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferenceDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isForward = this.getIsForward();
        result = result * 59 + ($isForward == null ? 43 : ((Object)$isForward).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        ExpandedNodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        QualifiedName $browseName = this.getBrowseName();
        result = result * 59 + ($browseName == null ? 43 : ((Object)$browseName).hashCode());
        LocalizedText $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        NodeClass $nodeClass = this.getNodeClass();
        result = result * 59 + ($nodeClass == null ? 43 : $nodeClass.hashCode());
        ExpandedNodeId $typeDefinition = this.getTypeDefinition();
        result = result * 59 + ($typeDefinition == null ? 43 : ((Object)$typeDefinition).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReferenceDescription(referenceTypeId=" + this.getReferenceTypeId() + ", isForward=" + this.getIsForward() + ", nodeId=" + this.getNodeId() + ", browseName=" + this.getBrowseName() + ", displayName=" + this.getDisplayName() + ", nodeClass=" + this.getNodeClass() + ", typeDefinition=" + this.getTypeDefinition() + ")";
    }

    private static final class ReferenceDescriptionBuilderImpl
    extends ReferenceDescriptionBuilder<ReferenceDescription, ReferenceDescriptionBuilderImpl> {
        private ReferenceDescriptionBuilderImpl() {
        }

        @Override
        protected ReferenceDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public ReferenceDescription build() {
            return new ReferenceDescription(this);
        }
    }

    public static abstract class ReferenceDescriptionBuilder<C extends ReferenceDescription, B extends ReferenceDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId referenceTypeId;
        private Boolean isForward;
        private ExpandedNodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private NodeClass nodeClass;
        private ExpandedNodeId typeDefinition;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReferenceDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReferenceDescription instance, ReferenceDescriptionBuilder<?, ?> b) {
            b.referenceTypeId(instance.referenceTypeId);
            b.isForward(instance.isForward);
            b.nodeId(instance.nodeId);
            b.browseName(instance.browseName);
            b.displayName(instance.displayName);
            b.nodeClass(instance.nodeClass);
            b.typeDefinition(instance.typeDefinition);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B isForward(Boolean isForward) {
            this.isForward = isForward;
            return (B)this.self();
        }

        public B nodeId(ExpandedNodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B browseName(QualifiedName browseName) {
            this.browseName = browseName;
            return (B)this.self();
        }

        public B displayName(LocalizedText displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        public B nodeClass(NodeClass nodeClass) {
            this.nodeClass = nodeClass;
            return (B)this.self();
        }

        public B typeDefinition(ExpandedNodeId typeDefinition) {
            this.typeDefinition = typeDefinition;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReferenceDescription.ReferenceDescriptionBuilder(super=" + super.toString() + ", referenceTypeId=" + this.referenceTypeId + ", isForward=" + this.isForward + ", nodeId=" + this.nodeId + ", browseName=" + this.browseName + ", displayName=" + this.displayName + ", nodeClass=" + this.nodeClass + ", typeDefinition=" + this.typeDefinition + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReferenceDescription> {
        @Override
        public Class<ReferenceDescription> getType() {
            return ReferenceDescription.class;
        }

        @Override
        public ReferenceDescription decode(SerializationContext context, UaDecoder decoder) {
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isForward = decoder.readBoolean("IsForward");
            ExpandedNodeId nodeId = decoder.readExpandedNodeId("NodeId");
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            ExpandedNodeId typeDefinition = decoder.readExpandedNodeId("TypeDefinition");
            return new ReferenceDescription(referenceTypeId, isForward, nodeId, browseName, displayName, nodeClass, typeDefinition);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReferenceDescription value) {
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IsForward", value.getIsForward());
            encoder.writeExpandedNodeId("NodeId", value.getNodeId());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeExpandedNodeId("TypeDefinition", value.getTypeDefinition());
        }
    }
}

